/***************************************************************************
*                               dlgIndividual.h
*                             -------------------
*
*    Revision     : $Id$
*    begin        : Tue Jan 29 2002
*    copyright    : (C) 2002 by Patrick Charbonnier
*                 : Based On Caitoo v.0.7.3 (c) 1998 - 2000, Matej Koss
*    email        : pch@freeshell.org
*
****************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 ***************************************************************************/

#ifndef __dlgprogress_h__
#define __dlgprogress_h__

#include <tqdatetime.h>

#include <tqwidget.h>

#include <kio/global.h>

class Transfer;

class TQLabel;
class TQRadioButton;
class TQTabWidget;
class TQTextEdit;
class TQCheckBox;
class KPushButton;
class KProgress;
class KToggleAction;
class KDateTimeWidget;

class DockIndividual;

class DlgIndividual:public TQWidget
{
  Q_OBJECT
  TQ_OBJECT
public:
    DlgIndividual(Transfer * _item);
    ~DlgIndividual()
    {}
    void setLog(const TQString & _msg);
    void appendLog(const TQString & _msg);
    void enableOpenFile();

public slots:
    void setTotalSize(KIO::filesize_t bytes);

    void setProcessedSize(KIO::filesize_t bytes);

    void setSpeed(TQString speed);
    void setPercent(unsigned long percent);

    void setCopying(const KURL & src, const KURL & dest);
    void setCanResume(bool);
    void slotKeepOpenToggled(bool);
    void slotOpenLocation();
    void slotOpenFile();

    bool keepDialogOpen() const { return bKeepDlgOpen; }
    
protected slots:
    void slotToggleAdvanced();
    void slotToggleDock();
    
protected:
    TQLabel *sourceLabel;
    TQLabel *destLabel;
    TQLabel *speedLabel;
    TQLabel *sizeLabel;
    TQLabel *resumeLabel;
    TQTextEdit *ml_log;

    KProgress *m_pProgressBar;
    DockIndividual * m_pDockIndividual;

    KPushButton   * openFile;
    KPushButton   * openLocation;
    KPushButton   * pbAdvanced ;

    TQTabWidget    * panelAdvanced;
    KToggleAction * m_paDock;

    TQDateTime qdt;
    KDateTimeWidget *spins;

    Transfer *item;

    KURL m_location;

    bool bKeepDlgOpen;

    KIO::filesize_t m_iTotalSize;
    
    bool advanced;
}

;

#endif                          // __dlgprogress_h__
