/***************************************************************************
                          usertabimpl.h  -  description
                             -------------------
    begin                : Mon Jul 15 2002
    copyright            : (C) 2002 by Jan Schfer
    email                : janschaefer@users.sourceforge.net
 ***************************************************************************/

/******************************************************************************
 *                                                                            *
 *  This file is part of KSambaPlugin.                                        *
 *                                                                            *
 *  KSambaPlugin is free software; you can redistribute it and/or modify      *
 *  it under the terms of the GNU General Public License as published by      *
 *  the Free Software Foundation; either version 2 of the License, or         *
 *  (at your option) any later version.                                       *
 *                                                                            *
 *  KSambaPlugin is distributed in the hope that it will be useful,           *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *  GNU General Public License for more details.                              *
 *                                                                            *
 *  You should have received a copy of the GNU General Public License         *
 *  along with KSambaPlugin; if not, write to the Free Software                     *
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA  *
 *                                                                            *
 ******************************************************************************/

#ifndef USERTABIMPL_H
#define USERTABIMPL_H

#include "usertab.h"
#include "common.h"
#include "tqstringlist.h"

/**
  *@author Jan Schfer
  */

class KListViewItem;
class SambaShare;

/**
 * Implements the usertab.ui interface
 * A Widget where you can add SambaUsers to the valid users, rejected users,
 * write list, read list and admin list parameters of the smb.conf file
 **/
class UserTabImpl : public UserTab
{
Q_OBJECT
  TQ_OBJECT
public:
	UserTabImpl(TQWidget* parent, SambaShare* share);
	~UserTabImpl();

  void load();
  void save();
private:
  SambaShare* _share;
  TQStringList _specifiedUsers;
  TQStringList _specifiedGroups;

  void setAllowedUser(int, const TQString &);
  void removeDuplicates( TQStringList & validUsers, TQStringList & readList,
                         TQStringList & writeList, TQStringList & adminUsers,
                         TQStringList & invalidUsers);

  void removeAll(TQStringList & entryList, TQStringList & fromList);
  void addListToUserTable(const TQStringList & list, int accessRight);
  void loadForceCombos();

  void loadUsers(const TQString & validUsersStr,
                 const TQString & readListStr,
                 const TQString & writeListStr,
                 const TQString & adminUsersStr,
                 const TQString & invalidUsersStr);

  void saveUsers(TQString & validUsersStr,
                 TQString & readListStr,
                 TQString & writeListStr,
                 TQString & adminUsersStr,
                 TQString & invalidUsersStr);

  bool nameIsGroup(const TQString & name);
  TQString removeGroupTag(const TQString & name);
  TQString removeQuotationMarks(const TQString & name);
  void addUserToUserTable(const TQString & user, int accessRight);

protected slots:
  virtual void addUserBtnClicked();
  virtual void addGroupBtnClicked();
  virtual void removeSelectedBtnClicked();
  virtual void expertBtnClicked();
};

#endif
