#include "prefs.h"
#include "voiceprint.h"

#include <klocale.h>
#include <kglobal.h>
#include <tqlabel.h>
#include <tqlayout.h>
#include <kcolorbutton.h>
#include <kconfig.h>

Prefs::Prefs(TQObject* parent)
	: CModule(i18n("Voiceprint"), i18n("Options for the Voiceprint Visualization"), "xapp", parent)
{
	TQVBoxLayout	*king=new TQVBoxLayout(this);
	TQHBoxLayout *minor;

	TQLabel *label;
	mForeground=new KColorButton(this);
	label=new TQLabel(mForeground, i18n("&Foreground color:"), this);
	minor=new TQHBoxLayout(king);
	minor->addWidget(label);
	minor->addWidget(mForeground);

	mBackground=new KColorButton(this);
	label=new TQLabel(mBackground, i18n("&Background color:"), this);
	minor=new TQHBoxLayout(king);
	minor->addWidget(label);
	minor->addWidget(mBackground);
	
	mLine=new KColorButton(this);
	label=new TQLabel(mForeground, i18n("&Sweep color:"), this);
	minor=new TQHBoxLayout(king);
	minor->addWidget(label);
	minor->addWidget(mLine);

	king->addStretch();
}

void Prefs::reopen()
{
	KConfig *config=KGlobal::config();
	config->setGroup("VoicePrint");
        TQColor black(0, 0, 0);
        TQColor blue(0, 0, 222);
	mBackground->setColor(config->readColorEntry("Background", &black));
	mForeground->setColor(config->readColorEntry("Foreground", &blue));
	mLine->setColor(config->readColorEntry("Line", &black));
}

void Prefs::save()
{
	KConfig *config=KGlobal::config();
	config->setGroup("VoicePrint");
	config->writeEntry("Background", mBackground->color());
	config->writeEntry("Foreground", mForeground->color());
	config->writeEntry("Line", mLine->color());

	config->sync();

	VoicePrint *l=VoicePrint::voicePrint;
	if (l)
		l->setColors(mBackground->color(), mForeground->color(), mLine->color());

}

#include "prefs.moc"

