/***************************************************************************
    copyright            : (C) 2004 Nathan Toone
    email                : nathan@toonetown.com
    copyright            : (C) 2007 Michael Pyne
    email                : michael.pyne@kdemail.net
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WEBIMAGEFETCHER_H
#define WEBIMAGEFETCHER_H

#include <kdialogbase.h>

#include <tqpixmap.h>
#include <tqstringlist.h>
#include <tqregexp.h>

#include "filehandle.h"

class KURL;

class TQHttp;

class WebImageFetcherDialog;

class WebImage
{
public:
    WebImage();

    WebImage(const TQString &imageURL,
                const TQString &thumbURL,
		int width, int height);

    TQString imageURL() const { return m_imageURL; }
    TQString thumbURL() const { return m_thumbURL; }
    TQString size() const { return m_size; }

private:
    TQString m_imageURL;
    TQString m_thumbURL;
    TQString m_size;
};

typedef TQValueList<WebImage> WebImageList;

class WebImageFetcher : public TQObject
{
    Q_OBJECT
  TQ_OBJECT

public:
    WebImageFetcher(TQObject *parent);
    ~WebImageFetcher();

    void setFile(const FileHandle &file);
    void chooseCover();

public slots:
    void abortSearch();

signals:
    void signalNewSearch(WebImageList &images);
    void signalCoverChanged(int coverId);

private:
    void displayWaitMessage();
    void requestNewSearchTerms(bool noResults = false);

private slots:
    void slotLoadImageURLs();
    void slotWebRequestFinished(int id, bool error);
    void slotCoverChosen();
    void slotNewSearch();

private:
    FileHandle m_file;
    TQString m_searchString;
    TQString m_loadedQuery;
    WebImageList m_imageList;
    uint m_selectedIndex;
    TQHttp *m_connection;
    int m_connectionId;
    WebImageFetcherDialog *m_dialog;
};
#endif
