/***************************************************************************
    copyright            : (C) 2002 by Daniel Molkentin
    email                : molkentin@kde.org

    copyright            : (C) 2002 - 2004 by Scott Wheeler
    email                : wheeler@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SYSTEMTRAY_H
#define SYSTEMTRAY_H

#include <ksystemtray.h>
#include <kpassivepopup.h>

#include <tqvaluevector.h>
#include <tqcolor.h>

class FlickerFreeLabel;
class TQTimer;
class TQVBox;
class FileHandle;

/**
 * Subclass of KPassivePopup intended to more easily support JuK's particular
 * usage pattern, including things like staying open while under the mouse.
 *
 * @author Michael Pyne <michael.pyne@kdemail.net>
 */
class PassiveInfo : public KPassivePopup
{
    Q_OBJECT
  TQ_OBJECT
public:
    PassiveInfo(TQWidget *parent = 0, const char *name = 0);

public slots:
    void setTimeout(int delay);
    virtual void show();

signals:
    void mouseEntered();
    void timeExpired();

protected:
    virtual void enterEvent(TQEvent *);
    virtual void leaveEvent(TQEvent *);

private slots:
    void timerExpired();

private:
    TQTimer *m_timer;
    bool m_justDie;
};

class SystemTray : public KSystemTray
{
    Q_OBJECT
  TQ_OBJECT

public:
    SystemTray(TQWidget *parent = 0, const char *name = 0);
    virtual ~SystemTray();

signals:
    // Emitted when the fade process is complete.
    void fadeDone();

private:
    static const int STEPS = 20; ///< Number of intermediate steps for fading.

    virtual void wheelEvent(TQWheelEvent *e);
    void createPopup();
    void setToolTip(const TQString &tip = TQString(), const TQPixmap &cover = TQPixmap());
    void mousePressEvent(TQMouseEvent *e);
    TQPixmap createPixmap(const TQString &pixName);

    // Returns true if the popup will need to have its buttons on the left
    // (because the JuK icon is on the left side of the screen.
    bool buttonsToLeft() const;

    void createButtonBox(TQWidget *parent);

    // Creates the widget layout for the popup, returning the TQVBox that
    // holds the text labels.  Uses buttonsToLeft() to figure out which
    // order to create them in.  @p file is used to grab the cover.
    TQVBox *createPopupLayout(TQWidget *parent, const FileHandle &file);

    void addSeparatorLine(TQWidget *parent);
    void addCoverButton(TQWidget *parent, const TQPixmap &cover);

    // Interpolates from start color to end color.  If @p step == 0, then
    // m_startColor is returned, while @p step == @steps returns
    // m_endColor.
    TQColor interpolateColor(int step, int steps = STEPS);

private slots:
    void slotPlay();
    void slotTogglePopup();
    void slotPause() { setPixmap(m_pausePix); }
    void slotStop();
    void slotPopupDestroyed(); 
    void slotNextStep(); ///< This is the fading routine.
    void slotPopupLargeCover();
    void slotForward();
    void slotBack();
    void slotFadeOut(); ///< Fades out the text
    void slotMouseInPopup(); ///< Forces the text back to its normal color.

private:
    TQPixmap m_playPix;
    TQPixmap m_pausePix;
    TQPixmap m_currentPix;
    TQPixmap m_backPix;
    TQPixmap m_forwardPix;
    TQPixmap m_appPix;
    TQColor m_startColor, m_endColor;

    PassiveInfo *m_popup;
    TQValueVector<FlickerFreeLabel *> m_labels;
    TQTimer *m_fadeTimer;
    int m_step;
    bool m_fade;
};

#endif // SYSTEMTRAY_H
