/***************************************************************************
                          Msgdlg  -  Send message to remote 
                             -------------------
    begin                : Thu Mar 30 2000
    copyright            : (C) |1995-2000 by Martin Heni
    email                : martin@heni-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
    Msgdlg.cpp

    $Id$
    
    Msg dialog for player names
    
    (c) Martin Heni, martin@heni-online.de
	      June 1999
    
    License: GPL

*/

#include <tqgroupbox.h>
#include <klocale.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>
#include "msgdlg.h"



// Create the dialog for changing the player names
MsgDlg::MsgDlg( TQWidget *parent, const char *name,const char * /*sufi */ )
    : TQDialog( parent, name,TRUE )
{
  setCaption(i18n("Send Message to Remote Player"));
  setMinimumSize(400,160);
  setMaximumSize(600,360);                                                        
  resize( 400, 160 );

  TQGroupBox* grp;
  grp = new TQGroupBox(i18n("Enter Message"), this);
  grp->resize(380,100);
  grp->move(10,10);

  MultiLine = new TQMultiLineEdit( grp, "MLineEdit" );
  MultiLine->setGeometry( 10, 20, 360, 70 );
  MultiLine->setText(TQCString("") );

  TQPushButton *PushButton;
  PushButton = new TQPushButton( i18n("Send" ), this, "PushButton_1" );
  PushButton->setGeometry( 20, 120, 65, 30 );
  connect( PushButton, TQT_SIGNAL(clicked()), TQT_SLOT(accept()) );
  PushButton->setAutoRepeat( FALSE );

  PushButton = new KPushButton( KStdGuiItem::cancel(), this, "PushButton_2" );
  PushButton->setGeometry( 305, 120, 65, 30 );
  connect( PushButton, TQT_SIGNAL(clicked()), TQT_SLOT(reject()) );
  PushButton->setAutoRepeat( FALSE );
}

TQString MsgDlg::GetMsg()
{
  return MultiLine->text();
}

#include "msgdlg.moc"
