/***************************************************************************
                          lskatview.h  -  description
                             -------------------
    begin                : Tue May  2 15:47:11 CEST 2000
    copyright            : (C) 2000 by Martin Heni
    email                : martin@heni-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LSKATVIEW_H
#define LSKATVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <tqwidget.h>
#include <tqrect.h>
#include "lskat.h"

class LSkatDoc;

/** The LSkatView class provides the view widget for the LSkatApp instance.
 * The View instance inherits TQWidget as a base class and represents the view object of a KTMainWindow. As LSkatView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the LSkatApp class to manipulate and display
 * the document structure provided by the LSkatDoc class.
 * 
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class LSkatView : public TQWidget
{
  Q_OBJECT
  TQ_OBJECT
  public:
  /** Constructor for the main view */
  LSkatView(TQWidget *parent = 0, const char *name=0);

  /** returns a pointer to the document connected to the view instance. Mind that this method requires a LSkatApp instance as a parent
   * widget to get to the window document pointer by calling the LSkatApp::getDocument() method.
   *
   * @see LSkatApp#getDocument
   */
  LSkatDoc *getDocument() const;

  void paintEvent( TQPaintEvent * p);
  void Paint(TQPainter *p);
  void InitMove(int player,int x,int y);
  void updateStatus();

  protected:
  void drawDeck(TQPainter *p);
  void drawIntro(TQPainter *p);
  void drawMove(TQPainter *p);
  void drawStatus(TQPainter *p);
  void drawFinal(TQPainter *p);
  void drawBorder(TQPainter *p,TQRect rect,int offset,int width,int mode);
  TQPoint calcCardPos(int x,int y);

  void mousePressEvent ( TQMouseEvent *m );

  protected slots:
  void moveTimerReady();
  void introTimerReady();
  void drawTabText(TQPainter *p,TQRect rect,TQString s,int *ts);


  private:
  TQRect status_rect1;
  TQRect status_rect2;
  TQRect status_rect3;
  TQTimer *moveTimer;
  TQTimer *introTimer;
  int introcnt;
  int cardmovecnt;
  int cardmovex,cardmovey;
  int cardmoveunder;
  TQPoint cardorigin;
  TQPoint cardend;
  int introCards[NO_OF_CARDS];

};

#endif // LSKATVIEW_H
