#include "types.h"

#include <klocale.h>
#include "version.h"

cId::cId(const TQString &_gameName, const TQString &_gameId)
: libId(MULTI_ID), gameName(_gameName), gameId(_gameId)
{}

void cId::check(const cId &id)
{
	if ( libId!=id.libId )            state = LibIdClash;
	else if ( gameName!=id.gameName ) state = GameNameClash;
	else if ( gameId!=id.gameId )     state = GameIdClash;
	else                              state = Accepted;
}

TQString cId::errorMessage(const cId &id) const
{
	TQString str = i18n("\nServer: \"%1\"\nClient: \"%2\"");

	switch (state) {
	 case Accepted: return TQString();
	 case LibIdClash:
		return i18n("The MultiPlayer library of the server is incompatible")
			+ str.arg(libId).arg(id.libId);
	 case GameNameClash:
		return i18n("Trying to connect a server for another game type")
			+ str.arg(gameName).arg(id.gameName);
	 case GameIdClash:
		return i18n("The server game version is incompatible")
			+ str.arg(gameId).arg(id.gameId);
	}
	Q_ASSERT(0);
	return TQString();
}

TQDataStream &operator << (TQDataStream &s, const cId &id)
{
	s << id.libId << id.gameName << id.gameId << (TQ_UINT8)id.state;
	return s;
}

TQDataStream &operator >> (TQDataStream &s, cId &id)
{
	TQ_UINT8 state;
	s >> id.libId >> id.gameName >> id.gameId >> state;
	id.state = (cId::State)state;
	return s;
}

//-----------------------------------------------------------------------------
TQDataStream &operator << (TQDataStream &s, const MeetingMsgFlag &f)
{
	s << (TQ_UINT8)f;
	return s;
}

TQDataStream &operator >> (TQDataStream &s, MeetingMsgFlag &f)
{
	TQ_UINT8 i;
	s >> i; f = (MeetingMsgFlag)i;
	return s;
}

//-----------------------------------------------------------------------------
TQDataStream &operator << (TQDataStream &s, const TextInfo &ti)
{
	s << (TQ_UINT32)ti.i << ti.text;
	return s;
}

TQDataStream &operator >> (TQDataStream &s, TextInfo &ti)
{
	TQ_UINT32 i;
	s >> i >> ti.text; ti.i = i;
	return s;
}

//-----------------------------------------------------------------------------
TQDataStream &operator << (TQDataStream &s, const MeetingCheckBox::Type &t)
{
	s << (TQ_UINT8)t;
	return s;
}

TQDataStream &operator >> (TQDataStream &s, MeetingCheckBox::Type &t)
{
	TQ_UINT8 i;
	s >> i; t = (MeetingCheckBox::Type)i;
	return s;
}

//-----------------------------------------------------------------------------
TQDataStream &operator << (TQDataStream &s, const TypeInfo &ti)
{
	s << (TQ_UINT32)ti.i << ti.type;
	return s;
}

TQDataStream &operator >> (TQDataStream &s, TypeInfo &ti)
{
	TQ_UINT32 i;
	s >> i >> ti.type; ti.i = i;
	return s;
}

//-----------------------------------------------------------------------------
TQDataStream &operator << (TQDataStream &s, const BoardData &bd)
{
	s << (TQ_UINT8)bd.type << bd.name;
	return s;
}

TQDataStream &operator >> (TQDataStream &s, BoardData &bd)
{
    TQ_UINT8 i;
	s >> i >> bd.name;
    bd.type = (PlayerComboBox::Type)i;
	return s;
}

//-----------------------------------------------------------------------------
TQDataStream &operator << (TQDataStream &s, const ExtData &ed)
{
	s << ed.bds << ed.text << ed.type;
	return s;
}

TQDataStream &operator >> (TQDataStream &s, ExtData &ed)
{
	s >> ed.bds >> ed.text >> ed.type;
	return s;
}

//-----------------------------------------------------------------------------
TQDataStream &operator << (TQDataStream &s, const MeetingLineData &pld)
{
	s << pld.ed;
	s << (TQ_UINT8)pld.own;
	return s;
}

TQDataStream &operator >> (TQDataStream &s, MeetingLineData &pld)
{
	TQ_UINT8 b;
	s >> pld.ed >> b; pld.own = b;
	return s;
}

//-----------------------------------------------------------------------------
TQDataStream &operator << (TQDataStream &s, const MetaFlag &f)
{
	s << (TQ_UINT8)f;
	return s;
}

TQDataStream &operator >> (TQDataStream &s, MetaFlag &f)
{
	TQ_UINT8 i;
	s >> i; f = (MetaFlag)i;
	return s;
}


//-----------------------------------------------------------------------------
Stream::Stream(int _mode)
: mode(_mode)
{
	setDevice(&buf);
	Q_ASSERT( _mode==IO_ReadOnly || _mode==IO_WriteOnly );
	buf.open((TQIODevice_OpenModeFlag)_mode);
}

void Stream::clear()
{
	buf.close();
	buf.open((TQIODevice_OpenModeFlag)(mode | IO_Truncate));
}

void Stream::setArray(TQByteArray a)
{
	buf.close();
	buf.setBuffer(a);
	buf.open((TQIODevice_OpenModeFlag)mode);
}

bool ReadingStream::readOk()
{
	return ( TQT_TQIODEVICE(&buf)->status()==IO_Ok );
}

void ReadingStream::clearRead()
{
	int i = buf.at();
	if ( i==0 ) return;
	buf.close();
	TQByteArray a;
	a.duplicate(buffer().data() + i, size() - i);
	buf.setBuffer(a);
	buf.open(IO_ReadOnly);
}

//-----------------------------------------------------------------------------
void IOBuffer::writingToReading()
{
	// this should do the trick :)
	reading.setArray(writing.buffer());
	TQByteArray a;
	writing.setArray(a);
}

//-----------------------------------------------------------------------------
void BufferArray::clear(uint k)
{
	for (uint i=k; i<a.size(); i++) delete a[i];
}

BufferArray::~BufferArray()
{
	clear(0);
}

void BufferArray::resize(uint nb)
{
	uint s = a.size();
	if ( nb<s ) clear(nb);
	a.resize(nb);
	for (uint i=s; i<nb; i++) a[i] = new IOBuffer;
}

TQDataStream &operator <<(TQDataStream &s, const BufferArray &b)
{
	for (uint i=0; i<b.size(); i++) {
		s.writeBytes(b[i]->writing.buffer().data(), b[i]->writing.size());
//		debug("BUFFERARRAY : << (i=%i size=%i)", i, b[i]->writing.size());
		b[i]->writing.clear();
	}
	return s;
}

TQDataStream &operator >>(TQDataStream &s, BufferArray &b)
{
	uint size;
	char *c;
	for (uint i=0; i<b.size(); i++) {
		s.readBytes(c, size);
		TQByteArray a;
		a.assign(c, size);
		b[i]->reading.setArray(a);
//		debug("BUFFERARRAY : >> (i=%i c=%i size=%i s=%i)",
//			  i, (int)c, size, b[i]->reading.size());
	}
	return s;
}
