#ifndef PLINE_H
#define PLINE_H

#include <tqframe.h>
#include <tqscrollbar.h>
#include <tqlineedit.h>
#include <tqlabel.h>
#include <tqptrlist.h>
#include <tqlayout.h>

#include "types.h"

class TQPushButton;

/** Internal class : display a "player line" in netmeeting. */
class MeetingLine : public TQFrame
{
 Q_OBJECT
  TQ_OBJECT

 public:
    MeetingLine(bool isOwner, bool readerIsServer, bool serverLine,
				TQWidget *parent, const char *name = 0);

	MeetingCheckBox::Type type() const { return tcb->type(); }
	void setType(MeetingCheckBox::Type type) { tcb->setType(type); }
	void setText(const TQString &text) { qle->setText(text); }

	void setData(const ExtData &ed);
	void data(ExtData &ed) const;
	TQString text() const { return qle->text(); }

 signals:
	void typeChanged(MeetingCheckBox::Type);
	void textChanged(const TQString &);

 private slots:
	void _typeChanged(int t)
		{ emit typeChanged((MeetingCheckBox::Type)t); }
	void _textChanged(const TQString &text) { emit textChanged(text); }

 protected:
	TQHBoxLayout *hbl;

 private:
	MeetingCheckBox       *tcb;
	TQLabel                *lname, *labH, *labAI;
	TQValueList<BoardData>  bds;
	TQLineEdit             *qle;
};

class PlayerLine : public TQFrame
{
 Q_OBJECT
  TQ_OBJECT

 public:
	PlayerLine(PlayerComboBox::Type type, const TQString &txt,
			   bool humanSetting, bool AISetting,
			   bool canBeEmpty, bool acceptAI,
			   TQWidget *parent = 0, const char *name = 0);

	PlayerComboBox::Type type() const { return pcb->type(); }
	TQString name() const { return edit->text(); }

 signals:
	void setHuman();
	void setAI();
	void typeChanged(int);

 private slots:
	void setSlot();
	void typeChangedSlot(int);

 private:
	PlayerComboBox *pcb;
	TQLineEdit      *edit;
	TQPushButton    *setting;
	bool            hs, as;
};

/** Internal class : scrolable list of widgets. */
class GWidgetList : public TQWidget
{
 Q_OBJECT
  TQ_OBJECT

 public:
	GWidgetList(uint interval, TQWidget *parent = 0, const char * name = 0);

	void remove(uint i);
	uint size() const { return widgets.count(); }

 protected:
	/** The widget must be created with this widget as parent. */
	void append(TQWidget *);
	TQWidget *widget(uint i) { return widgets.at(i); }

 private:
	TQPtrList<TQWidget> widgets;
	TQVBoxLayout vbl;
};

template <class Type>
class WidgetList : public GWidgetList
{
 public:
	WidgetList(uint interval, TQWidget *parent=0, const char *name=0)
	: GWidgetList(interval, parent, name) {}

	void append(Type *w) { GWidgetList::append(w); }
	Type *widget(uint i) { return (Type *)GWidgetList::widget(i); }
};

#endif // PLINE_H
