/*
    This file is part of the KDE games library
    Copyright (C) 2001 Andreas Beckermann (b_mann@gmx.de)
    Copyright (C) 2001 Martin Heni (martin@heni-online.de)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include <kmessagebox.h>
#include <klocale.h>
#include <kdebug.h>

#include "kgame.h"

#include "kgameerrordialog.h"

class KGameErrorDialogPrivate
{
public:
	KGameErrorDialogPrivate()
	{
		mGame = 0;
	}

	const KGame* mGame;
};

KGameErrorDialog::KGameErrorDialog(TQWidget* parent) : TQObject(parent)
{
 d = new KGameErrorDialogPrivate;
}

KGameErrorDialog::~KGameErrorDialog()
{
 delete d;
}

void KGameErrorDialog::setKGame(const KGame* g)
{
 slotUnsetKGame();
 d->mGame = g;

 connect(d->mGame, TQT_SIGNAL(destroyed()), this, TQT_SLOT(slotUnsetKGame()));

// the error signals:
 connect(d->mGame, TQT_SIGNAL(signalNetworkErrorMessage(int, TQString)), 
		this, TQT_SLOT(slotError(int, TQString)));
 connect(d->mGame, TQT_SIGNAL(signalConnectionBroken()), 
		this, TQT_SLOT(slotServerConnectionLost()));
 connect(d->mGame, TQT_SIGNAL(signalClientDisconnected(TQ_UINT32,bool)), 
		this, TQT_SLOT(slotClientConnectionLost(TQ_UINT32,bool)));
}

void KGameErrorDialog::slotUnsetKGame()
{
 if (d->mGame) {
	disconnect(d->mGame, 0, this, 0);
 }
 d->mGame = 0;
}

void KGameErrorDialog::error(const TQString& errorText, TQWidget* parent)
{ KMessageBox::error(parent, errorText); }

void KGameErrorDialog::slotServerConnectionLost()
{
// TODO: add IP/port of the server
 TQString message = i18n("Connection to the server has been lost!");
 error(message, (TQWidget*)parent());
}

void KGameErrorDialog::slotClientConnectionLost(TQ_UINT32 /*id*/,bool)
{
//TODO: add IP/port of the client
 TQString message;
// if (c) {
//	message = i18n("Connection to client has been lost!\nID: %1\nIP: %2").arg(c->id()).arg(c->IP());
// } else {
//	message = i18n("Connection to client has been lost!");
// }
 message = i18n("Connection to client has been lost!");
 error(message, (TQWidget*)parent());
}

void KGameErrorDialog::slotError(int errorNo, TQString text)
{
 TQString message = i18n("Received a network error!\nError number: %1\nError message: %2").arg(errorNo).arg(text);
 error(message, (TQWidget*)parent());
}

void KGameErrorDialog::connectionError(TQString s)
{
 TQString message;
 if (s.isNull()) {
	message = i18n("No connection could be created.");
 } else {
	message = i18n("No connection could be created.\nThe error message was:\n%1").arg(s);
 }
 error(message, (TQWidget*)parent());
}



// should become the real dialog - currently we just use messageboxes 
// -> maybe unused forever
KGameErrorMessageDialog::KGameErrorMessageDialog(TQWidget* parent) 
		: KDialogBase(Plain, i18n("Error"), Ok, Ok, parent, 0, true, true)
{
}

KGameErrorMessageDialog::~KGameErrorMessageDialog()
{
}



#include "kgameerrordialog.moc"
