/***************************************************************************
                                kwin4 program
                             -------------------
    begin                : Sun Mar 26 12:50:12 CEST 2000
    copyright            : (C) |1995-2000 by Martin Heni
    email                : martin@heni-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "scorewidget.h"

#include "prefs.h"

#include <tqlabel.h>
#include <tqlayout.h>
#include <tqpainter.h>
#include <tqsizepolicy.h>
#include <kdebug.h>
#include <klocale.h>

#define COL_STATUSBORDER black
#define COL_STATUSFIELD  TQColor(130,130,255)
#define COL_STATUSDARK   TQColor(0,0,65)
#define COL_STATUSLIGHT  TQColor(210,210,255)

ScoreWidget::ScoreWidget( TQWidget* parent,  const char* name, WFlags fl )
    : TQFrame( parent, name, fl )
{
  setFrameStyle( TQFrame::Box | TQFrame::Raised );
  setLineWidth( 2 );
  setMidLineWidth( 4 );
	
  setBackgroundColor( COL_STATUSFIELD );

   resize( 255, 187 ); 
   int row=0;

    setCaption( i18n( "Form1" ) );
    //LayoutB = new TQGridLayout( this,4,3,15,5 ); 
    LayoutB = new TQGridLayout( this);
    LayoutB->setSpacing( 3 );
    LayoutB->setMargin( 15 );

    TextLabel7 = new TQLabel( this, "TextLabel7" );
    setPlayer("-----",0);
    TextLabel7->setBackgroundColor( COL_STATUSFIELD );
    TextLabel7->setAlignment(TQt::AlignHCenter);
    LayoutB->addMultiCellWidget( TextLabel7, row, row,0,2 );
    row++;
    
    TextLabel8 = new TQLabel( this, "TextLabel8" );
    TextLabel8->setText( i18n( "vs" ) );
    TextLabel8->setBackgroundColor( COL_STATUSFIELD );
    TextLabel8->setAlignment(TQt::AlignHCenter);
    LayoutB->addMultiCellWidget( TextLabel8, row, row,0,2 );
    row++;
    
    TextLabel9 = new TQLabel( this, "TextLabel9" );
    setPlayer("-----",1);
  //  TextLabel9->setFrameShape(TQFrame::Box );
  //  TextLabel9->setLineWidth(5);
    TextLabel9->setBackgroundColor( COL_STATUSFIELD );
    TextLabel9->setAlignment(TQt::AlignHCenter);
    LayoutB->addMultiCellWidget( TextLabel9, row, row,0,2 );
    row++;

    TQSpacerItem *Spacer2=new TQSpacerItem(0,16,TQSizePolicy::Preferred,TQSizePolicy::Preferred);
    LayoutB->addMultiCell( Spacer2, row, row,0,2 );
    row++;

    TQSpacerItem *Spacer1=new TQSpacerItem(25,0,TQSizePolicy::Preferred,TQSizePolicy::Preferred);
    LayoutB->addMultiCell( Spacer1, row, row+2,1,1 );

    TextLabel1 = new TQLabel( this, "Level" );
    TextLabel1->setText( i18n( "Level" ) );
    TextLabel1->setBackgroundColor( COL_STATUSFIELD );
    LayoutB->addWidget( TextLabel1, row, 0 );

    TextLabel4 = new TQLabel( this, "L" );
    setLevel(Prefs::level());
    TextLabel4->setAlignment(TQt::AlignRight);
    TextLabel4->setBackgroundColor( COL_STATUSFIELD );
    LayoutB->addWidget( TextLabel4, row, 2 );

    row++;


    TextLabel2 = new TQLabel( this, "Move" );
    TextLabel2->setText( i18n("number of MOVE in game", "Move" ) );
    TextLabel2->setBackgroundColor( COL_STATUSFIELD );
    LayoutB->addWidget( TextLabel2, row, 0 );

    TextLabel5 = new TQLabel( this, "M" );
    setMove(0);
    TextLabel5->setAlignment(TQt::AlignRight);
    TextLabel5->setBackgroundColor( COL_STATUSFIELD );
    LayoutB->addWidget( TextLabel5, row, 2 );

    row++;


    TextLabel3 = new TQLabel( this, "Chance" );
    TextLabel3->setText( i18n( "Chance" ) );
    TextLabel3->setBackgroundColor( COL_STATUSFIELD );
    LayoutB->addWidget( TextLabel3, row, 0 );

    TextLabel6 = new TQLabel( this, "C" );
    setChance(0);
    TextLabel6->setAlignment(TQt::AlignRight);
    TextLabel6->setBackgroundColor( COL_STATUSFIELD );
    LayoutB->addWidget( TextLabel6, row, 2 );

    row++;

    TQSpacerItem *Spacer3=new TQSpacerItem(0,8,TQSizePolicy::Preferred,TQSizePolicy::Preferred);
    LayoutB->addMultiCell( Spacer3, row, row,0,2 );
    row++;



    adjustSize();
}

void ScoreWidget::paintEvent( TQPaintEvent * p)
{
    TQPainter paint( this );
    paint.setClipRect(p->rect());
    Paint( &paint, p->rect() );			
}

void ScoreWidget::Paint(TQPainter *p,TQRect /*cliprect*/)
{
  TQPalette pal;
  pal.setColor(TQColorGroup::Light, COL_STATUSLIGHT);
  pal.setColor(TQColorGroup::Mid, COL_STATUSFIELD);
  pal.setColor(TQColorGroup::Dark, COL_STATUSDARK);
  setPalette(pal); 
  drawFrame(p);
}

void ScoreWidget::setMove(int i)
{
  TextLabel5->setText( TQString("%1").arg(i));
}

void ScoreWidget::setLevel(int i)
{
  TextLabel4->setText( TQString("%1").arg(i));
}

void ScoreWidget::setChance(int i)
{
  if (i==0)
    TextLabel6->setText("    ----");
  else if (i>=999) 
    TextLabel6->setText(i18n("Winner"));
  else if (i<=-999) 
    TextLabel6->setText(i18n("Loser"));
  else
    TextLabel6->setText(TQString("%1").arg(i));
}

void ScoreWidget::setPlayer(TQString s,int no)
{
  if (no==0) TextLabel7->setText(s);
  else TextLabel9->setText(s);
}

void ScoreWidget::setTurn(int i)
{
  if (i==0)
  {
    TextLabel7->setPaletteForegroundColor ( yellow);
    TextLabel9->setPaletteForegroundColor (black);
  }
  else
  {
    TextLabel9->setPaletteForegroundColor ( red);
    TextLabel7->setPaletteForegroundColor (black);
  }
  TextLabel7->update();
  TextLabel9->update();
}

#include "scorewidget.moc"
