#include <tqstring.h>
#include <tqvaluelist.h>
#include <tqstringlist.h>
#include <tqfile.h>
#include <tqobject.h>

#include <kdebug.h>
#include <kglobal.h>
#include <kstandarddirs.h>
#include <ksimpleconfig.h>
#include <klibloader.h>

#include "pluginloader.h"

ObjectList *PluginLoader::loadAll()
{
	ObjectList *ret = new ObjectList;

	TQStringList libs;
	TQStringList files = KGlobal::dirs()->findAllResources("appdata", "*.plugin", false, true);

	for (TQStringList::Iterator it = files.begin(); it != files.end(); ++it)
	{
		KSimpleConfig cfg(*it);
		TQString filename(cfg.readEntry("Filename", ""));

		libs.append(filename);
	}

	for (TQStringList::Iterator it = libs.begin(); it != libs.end(); ++it)
	{
		Object *newObject = load(*it);
		if (newObject)
			ret->append(newObject);
	}

	return ret;
}

Object *PluginLoader::load(const TQString &filename)
{
	KLibFactory *factory = KLibLoader::self()->factory(filename.latin1());

	if (!factory)
	{
		kdWarning() << "no factory for " << filename << "!" << endl;
		return 0;
	}

	TQObject *newObject = factory->create(0, "objectInstance", "Object");
	
	if (!newObject)
	{
		kdWarning() << "no newObject for " << filename << "!" << endl;
		return 0;
	}

	Object *ret = dynamic_cast<Object *>(newObject);

	if (!ret)
		kdWarning() << "no ret for " << filename << "!" << endl;

	return ret;
}

