/***************************************************************************
                          kwordquizdoc.h  -  description
                             -------------------
    begin                : Wed Jul 24 20:12:30 PDT 2002
    copyright            : (C) 2002 by Peter Hedlund
    email                : peter.hedlund@kdemail.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWORDQUIZDOC_H
#define KWORDQUIZDOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT

// include files for KDE
#include <kurl.h>

// forward declaration of the KWordQuiz classes
class KWordQuizView;

/**	KWordQuizDoc provides a document object for a document-view model.
  *
  * The KWordQuizDoc class provides a document object that can be used in conjunction with the classes KWordQuizApp and KWordQuizView
  * to create a document-view model for standard KDE applications based on KApplication and KMainWindow. Thereby, the document object
  * is created by the KWordQuizApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KWordQuizView objects. Also, KWordQuizDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 1.2 code generation
  */
class KWordQuizDoc : public TQObject
{
  Q_OBJECT
  TQ_OBJECT
  public:
    /** Constructor for the fileclass of the application */
    KWordQuizDoc(TQWidget *parent, const char *name=0);
    /** Destructor for the fileclass of the application */
    ~KWordQuizDoc();

    /** adds a view to the document which represents the document contents. Usually this is your main view. */
    void addView(KWordQuizView *view);
    /** removes a view from the list of currently connected views */
    void removeView(KWordQuizView *view);
    /** sets the modified flag for the document after a modifying action on the view connected to the document.*/
    void setModified(bool _m=true);
    /** returns if the document is modified or not. Use this to determine if your document needs saving by the user on closing.*/
    bool isModified(){ return modified; }
    /** "save modified" - asks the user for saving if the document is modified */
    bool saveModified();	
    /** deletes the document's contents */
    void deleteContents();
    /** initializes the document generally */
    bool newDocument();
    /** closes the acutal document */
    void closeDocument();
    /** loads the document by filename */
    bool openDocument(const KURL& url, bool append = false, int index = 0);
    /** saves the document under filename and format.*/	
    bool saveDocument(const KURL& url, const char *format=0);
    /** returns the KURL of the document */
    const KURL& URL() const;
    /** sets the URL of the document */
	  void setURL(const KURL& url);
	
  public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
    void slotUpdateAllViews(KWordQuizView *sender);
    void slotModifiedOnDisk(const TQString &);
 	
  public:	
    /** the list of the views currently connected to the document */
    //static TQList<KWordQuizView> *pViewList;	
    //static KWordQuizView *m_view;
  private:
    /** the modified flag of the current document */
    bool modified;
    KURL doc_url;
    KWordQuizView *m_view;
};

#endif // KWORDQUIZDOC_H
