/***************************************************************************

                      blocking options for kvoctrain

    -----------------------------------------------------------------------

    begin                : Tue Apr 5 2005

    copyright            :(C) 2005 Peter Hedlund

    email                : peter.hedlund@kdemail.net

    -----------------------------------------------------------------------

 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BLOCKOPTIONS_H
#define BLOCKOPTIONS_H

#include <tqvaluelist.h>

#include "blockoptionsbase.h"
#include "QueryManager.h"

class TQComboBox;

class BlockOptions : public BlockOptionsBase
{
  Q_OBJECT
  TQ_OBJECT

public:
  BlockOptions(TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  void updateWidgets();
  bool hasChanged();
  bool isDefault();
  void updateSettings();

signals:
  void widgetModified();
  void blockExpireChanged(bool block, bool expire);

protected slots:
  void slotBlockToggled(bool);
  void slotExpireToggled(bool);
  void slotComboBoxActivated(int);

private:
  void fillWidgets();
  void fillComboBox(TQComboBox *);
  void updateComboBox(int, TQComboBox *);
  void checkValidity();

  TQValueList<TQComboBox *> m_blockComboList;
  TQValueList<TQComboBox *> m_expireComboList;
};

#endif

