/***************************************************************************
                          keducaview.h  -  description
                             -------------------
    begin                : Thu May 24 2001
    copyright            : (C) 2001 by Javier Campos
    email                : javi@asyris.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KEDUCAVIEW_H
#define KEDUCAVIEW_H

#include <kurl.h>

#include <tqlayout.h>
#include <tqsplitter.h>
#include <tqwidgetstack.h>

class TQTimer;
class TQTextEdit;
class TQLabel;

class KPushButton;

class FileRead;
class KQuestion;
class KGroupEduca;

/**Main view of keduca file (questions and answers)
   This is the widget for asking questions and allowing selection of answers
   as used by KEduca TestMaster (class KEduca)
 *@author Javier Campos
 */

class KEducaView : public TQWidgetStack
{
    Q_OBJECT
  TQ_OBJECT

public:
    KEducaView(TQWidget *parent=0, const char *name=0);
    ~KEducaView();
    /** Open url */
    bool openURL( const KURL &url);
    FileRead const *getKeducaFile() const {return _keducaFile; }

private:

    // Private methods

    /** Init graphical interface */
    void init();
    /** Show record, returns false if there is no record to show. */
    void showRecord();
    /** Show results */
    void showResults( const TQString &text );
    /** Set results */
    void setResults();
    /** Set results */
    TQString setFinalResult();
    /** Write settings */
    void configWrite();
    /** current results Points */
    TQString currentStatusPoints();
    /** Set HTML table view with correct and incorrect answers */
    TQString getTableQuestion( bool isCorrect, const TQString &correct, const TQString &incorrect);
    /** Define the next questions (random, secuencial) */
    bool questionNext();

    TQString getInformation();
    /** Init table with title and colspan */
    TQString insertTable( const TQString &title = "", unsigned int col=0);
    /** Insert row */
    TQString insertRow( const TQString &text, bool title, unsigned int colSpan=0 );
    TQString insertRow( const TQString &label, const TQString &field, bool formBased );
    TQString insertRow( const TQString &label1, const TQString &field1, const TQString &label2, const TQString &field2, bool formBased );
    /** Close current table */
    TQString insertTableClose();
            
    // Private attributes

    /** Widgets */
    TQLabel *_introWidget;
    TQWidget *_infoWidget, *_questionWidget, *_resultsWidget;
    /** Push Buttons */
    KPushButton *_buttonNext;
    KPushButton *_buttonSave;
    KPushButton *_buttonResultsNext; // FIXME: this is a hack
    KPushButton *_buttonStartTest;
    /** Group of answers. This is a frame an check or radio buttons. */
    KGroupEduca *_buttonGroup;
    /** KEDUCA file */
    FileRead *_keducaFile;
    /** A question text with pixmaps and movies support */
    KQuestion *_questionText;
    /** A question text with pixmaps and movies support */
    TQTextEdit *_viewResults;
    TQTextEdit *_viewInfo;
    /** Current record */
    int _keducaFileIndex;
    /** Current results */
    TQString _results;
    /** Main vbox */
    TQVBoxLayout *_vbox2;
    /** Main splitt */
    TQSplitter *_split;
    /** Current results */
    TQString _currentResults;
    /** If is init window */
    bool _isInitStatus;
    TQTimer *_timeoutTimer;
    /** Num of correct answers */
    int _correctAnswer;
    /** Number of incorrect answers */
    int _incorrectAnswer;
    /** Number of correct answers in points*/
    int _correctPoints;
    /** Number of incorrect answers in points*/
    int _incorrectPoints;
    /** Current time */
    int _currentTime;
    /** Show results when finish? */
    bool _showResultFinish;
    /** Show random questions */
    bool _showRandomQuestions;
    /** Show random answers */
    bool _showRandomAnswers;
    /** Save real order by random questions */
    TQValueList<uint> _randomQuestions;
    /** Save real order by random answers */
    TQValueList<uint> _randomAnswers;
private slots:
    /** Button Next action */
    void slotButtonNext();
    void slotButtonSave();
    void slotButtonStartTest();
    void questionTimedOut();
};

#endif
