// (c) 2000 Peter Putzer

#ifndef PREFERENCES_DIALOG_H
#define PREFERENCES_DIALOG_H

#include <tqstring.h>
#include <kdialogbase.h>

class TQPushButton;

class KSVLookAndFeel;
class KSVMiscConfig;
class KSVPathConfig;
class KSVConfig;


class KSVPreferences : public KDialogBase
{
  Q_OBJECT
  TQ_OBJECT

public:
  static KSVPreferences* self ();
  virtual ~KSVPreferences ();

  TQColor newNormal () const;
  TQColor newSelected () const;
  TQColor changedNormal () const;
  TQColor changedSelected () const;

  TQString runlevelPath () const;
  TQString scriptPath () const;

protected:
  virtual void showEvent (TQShowEvent* e);

signals:
  void updateColors ();
  void updateServicesPath ();
  void updateRunlevelsPath ();
  void updateFonts ();

protected slots:
  virtual void slotApply ();
  virtual void slotCancel ();
  virtual void slotOk ();
  void slotChanged();

private slots:
  void reReadConfig();
  void showAllMessages ();

private:
  friend class KSVTopLevel;

  KSVPreferences (TQWidget* parent);
  void setConfig ();
  bool checkPaths();
  void reReadMessages();
  KSVConfig* mConfig;

  KSVLookAndFeel* mLookAndFeel;
  KSVPathConfig* mPathConfig;
  KSVMiscConfig* mMiscConfig;
  bool configChanged;
};


#endif // PREFERENCES_DIALOG_H
