/* This file is part of the KDE project

   Copyright (C) 2001, 2003 Lukas Tinkl <lukas@kde.org>
                      Andreas Schlapbach <schlpbch@iam.unibe.ch>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License version 2 as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef kimdialogplugin_h
#define kimdialogplugin_h


#include <kdialogbase.h>

class TQProgressDialog;
class KURL;
class KIntNumInput;
class TQCheckBox;
class TQLineEdit;
class KURLRequester;
class TQSpinBox;
class KColorButton;
class KConfig;

typedef TQMap<TQString,TQString> CommentMap;

class KIGPDialog : public KDialogBase
{
 Q_OBJECT
  TQ_OBJECT

 public:
  KIGPDialog(TQWidget *parent=0, const TQString& path=0, const char *name=0 );
  ~KIGPDialog();

  bool isDialogOk() const;
  bool printImageName() const;
  bool printImageSize() const;
  bool printImageProperty() const;
  bool copyOriginalFiles() const;
  bool useCommentFile() const;
  bool recurseSubDirectories() const;
  int recursionLevel() const;
  bool colorDepthSet() const;

  int getImagesPerRow() const;
  int getThumbnailSize() const;
  int getColorDepth() const;

  const TQString getTitle() const;
  const TQString getImageName() const;
  const TQString getCommentFile() const;
  const TQString getFontName() const;
  const TQString getFontSize() const;

  const TQColor getBackgroundColor() const;
  const TQColor getForegroundColor() const;

  const TQString getImageFormat() const;

  void writeConfig();
 protected slots:
  void imageUrlChanged(const TQString & );
  void slotDefault();

 private:
  KColorButton *m_foregroundColor;
  KColorButton *m_backgroundColor;

  TQLineEdit *m_title;
  TQString m_path;

  KIntNumInput *m_imagesPerRow;
  KIntNumInput *m_thumbnailSize;
  KIntNumInput *m_recursionLevel;
  TQSpinBox *m_fontSize;

  TQCheckBox *m_copyOriginalFiles;
  TQCheckBox *m_imageName;
  TQCheckBox *m_imageSize;
  TQCheckBox *m_imageProperty;
  TQCheckBox *m_useCommentFile;
  TQCheckBox *m_recurseSubDir;
  TQCheckBox *m_colorDepthSet;

  TQComboBox* m_fontName;
  TQComboBox* m_imageFormat;
  TQComboBox* m_colorDepth;

  KURLRequester *m_imageNameReq;
  KURLRequester *m_commentFileReq;
  bool m_dialogOk;

  KConfig *m_config;

 private:
  void setupLookPage(const TQString& path);
  void setupDirectoryPage(const TQString& path);
  void setupThumbnailPage(const TQString& path);
};

#endif
