#ifndef ATLANTK_DESIGNER_H
#define ATLANTK_DESIGNER_H

#include <tqcolor.h>
#include <tqguardedptr.h>
#include <tqptrlist.h>
#include <tqstring.h>
#include <tqvaluelist.h>

#include <kmainwindow.h>

#include "boardinfo.h"
#include "group.h"
#include "editor.h"

class EstateEdit;
class TQCloseEvent;
class KListAction;
class KRecentFilesAction;
class Estate;
class Player;
class ConfigEstate;
class AtlantikBoard;

class AtlanticDesigner : public KMainWindow
{
	Q_OBJECT
  TQ_OBJECT

	public:
	AtlanticDesigner(TQWidget *parent = 0, const char *name = 0);
	~AtlanticDesigner();

	protected:
	void closeEvent(TQCloseEvent *);

	public slots:
	void modified();

	private slots:
	void open();
	void openRecent(const KURL &);
	void openNew();
	void save();
	void saveAs();
	void copy();
	void paste();
	void changeEstate(int);
	void changeEstate(Estate *);
	void movePlayer(Estate *);
	void setPlayerAtBeginning();
	void info();
	void editGroups();
	void groupsChanged();
	void goChanged(int);
	void updateBackground();

	void up();
	void down();
	void left();
	void right();

	void smaller();
	void larger();

	void updateJumpMenu();

	private:
	void openFile(const TQString &);
	bool warnClose();
	void initBoard();
	void initMembers();
	void initToken();
	bool firstBoard;
	ConfigEstate *newEstate(int);

	TQGuardedPtr<EstateEdit> editor;
	TQGuardedPtr<TQVBoxLayout> layout;
	TQGuardedPtr<AtlantikBoard> board;
	TQGuardedPtr<GroupEditor> groupEditor;
	TQGuardedPtr<BoardInfoDlg> boardInfoDlg;
	EstateList estates;
	KListAction *estateAct;
	KRecentFilesAction *recentAct;

	TQValueList<CardStack> cards;
	BoardInfo boardInfo;
	ConfigEstateGroupList groups;

	TQString filename;

	ConfigEstate *copiedEstate;

	void doCaption(bool);

	int max;
	TQStringList types;

	Player *m_player;

	bool isMod;

	TQColor defaultFg;
	TQColor defaultBg;
};

#endif
