/*
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
*/

/*
  Copyright (C) 2005 Francois Chazal <neptune3k@free.fr>
  Copyright (C) 2006-2007 Eike Hein <hein@kde.org>
*/


#ifndef TABBED_WIDGET_H
#define TABBED_WIDGET_H


#include "translucent_widget.h"

#include <tqfont.h>
#include <tqcolor.h>
#include <tqpoint.h>
#include <tqpixmap.h>
#include <tqpainter.h>
#include <tqlineedit.h>
#include <tqvaluelist.h>
#include <tqfontmetrics.h>

#include <klocale.h>
#include <krootpixmap.h>
#include <kinputdialog.h>


class KPopupMenu;

class TabbedWidget : public TranslucentWidget
{
    Q_OBJECT
  TQ_OBJECT

    public:
        explicit TabbedWidget(TQWidget* parent = 0, const char* name = 0, bool translucency = false);
        ~TabbedWidget();

        int pressedPosition();
        void resetPressedPosition() { pressed_position = -1; }

        void addItem(int session_id);
        int removeItem(int session_id);

        int tabPositionForSessionId(int session_id);
        int sessionIdForTabPosition(int position);

        void selectItem(int session_id);
        void selectPosition(int position);

        void selectNextItem();
        void selectPreviousItem();

        void moveItemLeft();
        void moveItemLeft(int position);

        void moveItemRight();
        void moveItemRight(int position);

        const TQString itemName(int session_id);
        void renameItem(int session_id, const TQString& name);

        void interactiveRename();
        void interactiveRename(int position);

        void setFontColor(const TQColor& color);
        void setBackgroundPixmap(const TQString& path);
        void setSeparatorPixmap(const TQString& path);

        void setUnselectedPixmap(const TQString& path);

        void setSelectedPixmap(const TQString& path);
        void setSelectedLeftPixmap(const TQString& path);
        void setSelectedRightPixmap(const TQString& path);

        void refreshBuffer();


    signals:
        void addItem();
        void itemSelected(int session_id);


    protected:
        virtual void keyPressEvent(TQKeyEvent*);

        virtual void wheelEvent(TQWheelEvent*);
        virtual void mousePressEvent(TQMouseEvent*);
        virtual void mouseReleaseEvent(TQMouseEvent*);
        virtual void mouseDoubleClickEvent(TQMouseEvent*);

        virtual void leaveEvent(TQEvent*);

        virtual void paintEvent(TQPaintEvent*);


    private:
        void createContextMenu();
        const int drawButton(int position, TQPainter& painter);
        TQString defaultTabCaption(int session_id);
        TQString lowestAvailableCaption();

        int current_position;
        bool pressed;
        int pressed_position;
        int edited_position;

        /* Tabs properties */
        TQColor font_color;
        TQFont selected_font;
        TQFont unselected_font;

        /* Inline renaming */
        TQLineEdit* inline_edit;

        /* Widget's pixmaps */
        TQPixmap background_image;

        TQPixmap separator_image;
        TQPixmap unselected_image;

        TQPixmap selected_image;
        TQPixmap selected_left_image;
        TQPixmap selected_right_image;

        /* Widget's appearance */
        TQPixmap buffer_image;
        TQPixmap desktop_image;

        /* Tabs value lists */
        TQValueList<int> items;
        TQValueList<int> areas;
        TQValueList<TQString> captions;

        KPopupMenu* context_menu;


    private slots:
        void slotRenameSelected();
        void slotUpdateBuffer(const TQPixmap& pixmap);
        void slotResetEditedPosition();
};

#endif /* TABBED_WIDGET_H */
