/***************************************************************************
 *   Copyright (C) 2005 by Pawel Nawrocki                                  *
 *   pnawrocki@interia.pl                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef WLASSISTANT_H
#define WLASSISTANT_H

//connection check interval in msec
#define WA_CONNECTION_CHECK_INTERVAL 5000

#include <tqlistview.h>

#include "ui_main.h"
#include "waconfig.h"

#include "netparams.h"

class TQTimer;
class TQProcess;
class NetListViewItem;

class WirelessAssistant : public mainWindow
{
        Q_OBJECT
  TQ_OBJECT

public:
        /*$PUBLIC_FUNCTIONS$*/
        WirelessAssistant(TQWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
        ~WirelessAssistant();

        static TQString getVal(const TQString & str, const TQString & rxs);

public slots:
        /*$PUBLIC_SLOTS$*/
        virtual void netConnect();
        virtual void netScan();
        virtual void netDisconnect( const bool & quiet = false);

private:
        void netScan( const WANetParams & np );
        void netConnect( const WANetParams & np );
        void setDNS( const WANetParams & np );
        void readConfig();
        void saveSettings();
        void setUi(int uiState);
        void setSingleClick(bool i);
        TQString runCommand( const TQStringList & cmd, int timeout = 0, bool detached = 0 );
        void setNetParamsFromList( TQListViewItem* lvi );
        bool setNetParamsFromConfig( const TQString & s );
        TQString matchEssidForAp( const TQString & ap );
	bool radioEnabled();
	TQListViewItem* getItemByAp( const TQString & ap );
	TQListViewItem* getItemByEssid( const TQString & essid );
	void setConnectedItem( const TQString & netid );
	TQString getGateway();
	bool dhcpClientRunning();
	TQStringList interfaceList();
	bool generateWpaConfigFile( const TQString& essid, const TQStringList& wpaSettings, const TQString& wpaKey );
	bool setWpaClientEnabled( bool e, const TQString& iface = 0, TQString driver = 0 );
	
	TQStringList NetParamsList;
        TQStringList execsNotFound;
        NetListViewItem* connectedItem;
	TQString wpaConfigFile;
        /// settings saved in wlassistantrc
        bool autoQuit;
	bool autoReconnect;
	bool autoConnect;
	bool groupAPs;
	bool wpaAvailable;
	int DelayBeforeScanning;
        int DhcpTimeout;
        /*TQString dhcpcdInfoPath;
        TQString dhclientInfoPath;
        TQString dhcpcdPidPath;
        TQString dhclientPidPath;*/
        /// end settings.

        WACommands Commands;
        WANetParams NetParams;
        TQTimer* timerGui;
        TQTimer* timerConnectionCheck;

protected slots:
        /*$PROTECTED_SLOTS$*/
        virtual void init();
	virtual void netAutoConnect();
        virtual void parseScan( const TQString & output );
        virtual void setDev( const TQString & ifname);
        virtual void setNetListColumns();
        virtual void updateConfiguration(int category = -1);
        virtual void updateConnectedItem();
        virtual void showItemContextMenu( TQListViewItem* i, const TQPoint& p, int c);
        virtual void editNetParams();
        virtual void removeNetParams();
        virtual void updateNetParams();
        virtual void itemAction();
        virtual void checkConnectionStatus();
        virtual void updateConnectButton(TQListViewItem* lvi);
        virtual void setMouseBehaviour();
        virtual void togglePage(bool options );
        virtual void enableAllMessages();
        virtual bool close();
};

#endif
