/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICOXMLEXPORTER_H
#define TELLICOXMLEXPORTER_H

namespace Tellico {
  class Filter;
}

class TQDomDocument;
class TQDomElement;
class TQCheckBox;

#include "exporter.h"
#include "../stringset.h"

namespace Tellico {
  namespace Export {

/**
 * @author Robby Stephenson
 */
class TellicoXMLExporter : public Exporter {
Q_OBJECT
  TQ_OBJECT

public:
  TellicoXMLExporter();
  TellicoXMLExporter(Data::CollPtr coll);

  virtual bool exec();
  virtual TQString formatString() const;
  virtual TQString fileFilter() const;

  TQDomDocument exportXML() const;
  TQString exportXMLString() const;

  void setIncludeImages(bool b) { m_includeImages = b; }
  void setIncludeGroups(bool b) { m_includeGroups = b; }

  virtual TQWidget* widget(TQWidget*, const char*);
  virtual void readOptions(KConfig* cfg);
  virtual void saveOptions(KConfig* cfg);

  /**
   * An integer indicating format version.
   */
  static const unsigned syntaxVersion;

private:
  void exportCollectionXML(TQDomDocument& doc, TQDomElement& parent, bool format) const;
  void exportFieldXML(TQDomDocument& doc, TQDomElement& parent, Data::FieldPtr field) const;
  void exportEntryXML(TQDomDocument& doc, TQDomElement& parent, Data::EntryPtr entry, bool format) const;
  void exportImageXML(TQDomDocument& doc, TQDomElement& parent, const TQString& imageID) const;
  void exportGroupXML(TQDomDocument& doc, TQDomElement& parent) const;
  void exportFilterXML(TQDomDocument& doc, TQDomElement& parent, FilterPtr filter) const;
  void exportBorrowerXML(TQDomDocument& doc, TQDomElement& parent, Data::BorrowerPtr borrower) const;

  // keep track of which images were written, since some entries could have same image
  mutable StringSet m_images;
  bool m_includeImages : 1;
  bool m_includeGroups : 1;

  TQWidget* m_widget;
  TQCheckBox* m_checkIncludeImages;
};

  } // end namespace
} // end namespace
#endif
