/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef ONIXEXPORTER_H
#define ONIXEXPORTER_H

class TQCheckBox;

#include "exporter.h"

namespace Tellico {
  namespace Data {
    class Collection;
  }
  class XSLTHandler;
  namespace Export {

/**
 * @author Robby Stephenson
 */
class ONIXExporter : public Exporter {
Q_OBJECT
  TQ_OBJECT

public:
  ONIXExporter();
  ONIXExporter(Data::CollPtr coll);
  ~ONIXExporter();

  virtual bool exec();
  virtual TQString formatString() const;
  virtual TQString fileFilter() const;

  virtual TQWidget* widget(TQWidget*, const char* name=0);
  virtual void readOptions(KConfig*);
  virtual void saveOptions(KConfig*);

  TQString text();

private:
  XSLTHandler* m_handler;
  TQString m_xsltFile;
  bool m_includeImages;

  TQWidget* m_widget;
  TQCheckBox* m_checkIncludeImages;
};

  } // end namespace
} // end namespace
#endif
