/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_IMPORT_GCFILMSIMPORTER_H
#define TELLICO_IMPORT_GCFILMSIMPORTER_H

#include "textimporter.h"
#include "../datavectors.h"

class TQRegExp;

namespace Tellico {
  namespace Import {

/**
 * @author Robby Stephenson
*/
class GCfilmsImporter : public TextImporter {
Q_OBJECT
  TQ_OBJECT

public:
  /**
   */
  GCfilmsImporter(const KURL& url);

  /**
   *
   */
  virtual Data::CollPtr collection();
  /**
   */
  virtual TQWidget* widget(TQWidget*, const char*) { return 0; }
  virtual bool canImport(int type) const;

public slots:
  void slotCancel();

private:
  static TQString splitJoin(const TQRegExp& rx, const TQString& s);

  void readGCfilms(const TQString& text);
  void readGCstar(const TQString& text);

  Data::CollPtr m_coll;
  bool m_cancelled;
};

  } // end namespace
} // end namespace
#endif
