/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICOIMAGEWIDGET_H
#define TELLICOIMAGEWIDGET_H

#include <kurl.h>
#include <tqwidget.h>
#include <tqpixmap.h>
#include <tqpoint.h>

class TQLabel;
class TQResizeEvent;
class TQMouseEvent;
class TQDragEnterEvent;
class TQDropEvent;
class TQCheckBox;

namespace Tellico {
  namespace GUI {

/**
 * @author Robby Stephenson
 */
class ImageWidget : public TQWidget {
Q_OBJECT
  TQ_OBJECT

public:
  ImageWidget(TQWidget* parent, const char* name = 0);
  virtual ~ImageWidget() {}

  const TQString& id() const { return m_imageID; }
  void setImage(const TQString& id);
  void setLinkOnlyChecked(bool l);

public slots:
  void slotClear();

signals:
  void signalModified();

protected:
  virtual void resizeEvent(TQResizeEvent* ev);
  virtual void mousePressEvent(TQMouseEvent* ev);
  virtual void mouseMoveEvent(TQMouseEvent* ev);
  virtual void dragEnterEvent(TQDragEnterEvent* ev);
  virtual void dropEvent(TQDropEvent* ev);

private slots:
  void slotGetImage();
  void slotLinkOnlyClicked();

private:
  void scale();
  void loadImage(const KURL& url);

  TQString m_imageID;
  TQPixmap m_pixmap;
  TQPixmap m_scaled;
  TQLabel* m_label;
  TQCheckBox* m_cbLinkOnly;
  KURL m_originalURL;
  TQPoint m_dragStart;
};

  } // end GUI namespace
} // end namespace
#endif
