/***************************************************************************
    copyright            : (C) 2005-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef COUNTEDITEM_H
#define COUNTEDITEM_H

#include "listview.h"

class TQPainter;
class TQColorGroup;
class TQFontMetrics;

namespace Tellico {
  namespace GUI {

/**
 * @author Robby Stephenson
 */
class CountedItem : public GUI::ListViewItem {
public:
  CountedItem(ListView* parent) : ListViewItem(parent) {}
  CountedItem(ListViewItem* parent) : ListViewItem(parent) {}

  virtual int compare(TQListViewItem* item, int col, bool ascending) const;
  /**
   * Paints the cell, adding the number count.
   */
  virtual void paintCell(TQPainter* p, const TQColorGroup& cg,
                         int column, int width, int align);
  virtual int width(const TQFontMetrics& fm, const TQListView* lv, int c) const;

  virtual int count() const { return childCount(); }
  virtual int realChildCount() const { return count(); }
};

  } // end namespace
} // end namespace

#endif
