/***************************************************************************
    copyright            : (C) 2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef TELLICO_FETCH_ANIMENFOFETCHER_H
#define TELLICO_FETCH_ANIMENFOFETCHER_H

#include "fetcher.h"
#include "configwidget.h"

#include <tqcstring.h> // for TQByteArray
#include <tqguardedptr.h>

namespace KIO {
  class Job;
}

namespace Tellico {
  namespace Fetch {

/**
 * A fetcher for animenfo.com
 *
 * @author Robby Stephenson
 */
class AnimeNfoFetcher : public Fetcher {
Q_OBJECT
  TQ_OBJECT

public:
  AnimeNfoFetcher(TQObject* parent, const char* name = 0);
  virtual ~AnimeNfoFetcher() {}

  virtual TQString source() const;
  virtual bool isSearching() const { return m_started; }
  virtual void search(FetchKey key, const TQString& value);
  // only keyword search
  virtual bool canSearch(FetchKey k) const { return k == Keyword; }
  virtual void stop();
  virtual Data::EntryPtr fetchEntry(uint uid);
  virtual Type type() const { return AnimeNfo; }
  virtual bool canFetch(int type) const;
  virtual void readConfigHook(const KConfigGroup& config);

  virtual void updateEntry(Data::EntryPtr entry);

  virtual Fetch::ConfigWidget* configWidget(TQWidget* parent) const;

  class ConfigWidget : public Fetch::ConfigWidget {
  public:
    ConfigWidget(TQWidget* parent_);
    virtual void saveConfig(KConfigGroup&) {}
    virtual TQString preferredName() const;
  };
  friend class ConfigWidget;

  static TQString defaultName();

private slots:
  void slotData(KIO::Job* job, const TQByteArray& data);
  void slotComplete(KIO::Job* job);

private:
  Data::EntryPtr parseEntry(const TQString& str);

  TQByteArray m_data;
  int m_total;
  TQMap<int, Data::EntryPtr> m_entries;
  TQMap<int, KURL> m_matches;
  TQGuardedPtr<KIO::Job> m_job;

  bool m_started;
//  TQStringList m_fields;
};

  } // end namespace
} // end namespace
#endif
