/***************************************************************************
    copyright            : (C) 2003-2006 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef BIBTEXCOLLECTION_H
#define BIBTEXCOLLECTION_H

#include "../collection.h"

namespace Tellico {
  namespace Data {

/**
 * A collection specifically for bibliographies, in Bibtex format.
 *
 * It has the following standard attributes:
 * @li Title
 *
 * @author Robby Stephenson
 */
class BibtexCollection : public Collection {
Q_OBJECT
  TQ_OBJECT

public:
  /**
   * The constructor
   *
   * @param addFields A boolean indicating whether the default attributes should be added
   * @param title The title of the collection
   */
  BibtexCollection(bool addFields, const TQString& title = TQString());
  /**
   */
  virtual ~BibtexCollection() {}

  virtual Type type() const { return Bibtex; }
  virtual bool addField(FieldPtr field);
  virtual bool modifyField(FieldPtr field);
  virtual bool deleteField(FieldPtr field, bool force=false);

  FieldPtr fieldByBibtexName(const TQString& name) const;
  const TQString& preamble() const { return m_preamble; }
  void setPreamble(const TQString& preamble) { m_preamble = preamble; }
  const StringMap& macroList() const { return m_macros; }
  void setMacroList(StringMap map) { m_macros = map; }
  void addMacro(const TQString& key, const TQString& value) { m_macros.insert(key, value); }

  virtual int sameEntry(Data::EntryPtr entry1, Data::EntryPtr entry2) const;

  static FieldVec defaultFields();
  static CollPtr convertBookCollection(CollPtr coll);

private:
  TQDict<Field> m_bibtexFieldDict;
  TQString m_preamble;
  StringMap m_macros;
};

  } // end namespace
} // end namespace
#endif
