
#include "soundkonverter.h"
#include "config.h"
#include "configdialog.h"
#include "logger.h"
#include "logviewer.h"
#include "options.h"
#include "filelist.h"
#include "progressindicator.h"
#include "cdmanager.h"
#include "cdopener.h"
#include "tagengine.h"
#include "combobutton.h"
#include "convert.h"
#include "progressindicator.h"
#include "replaygainscanner.h"
#include "cuesheeteditor.h"
// ### #include "aboutplugins.h" delayed to a future soundkonverter version
#include "optionsrequester.h"
#include "dirdialog.h"

#include <kapplication.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kfiledialog.h>
#include <kinputdialog.h>
#include <kpushbutton.h>
#include <kpopupmenu.h>
//#include <kmenubar.h>
#include <kaction.h>
#include <kstdaction.h>
#include <kedittoolbar.h>
#include <kmessagebox.h>
#include <kstddirs.h>
#include <kio/job.h>
#include <kprocess.h>
#include <ksystemtray.h>

#include <tqlayout.h>
#include <tqprogressbar.h>
#include <tqfont.h>
#include <tqhbox.h>
#include <tqeventloop.h>

// TODO stop all processes on exit / clean tmp up

// ### soundkonverter 0.4: save file list when kde session gets terminated

soundKonverter::soundKonverter()
    : KMainWindow( 0, "soundkonverter-mainwindow", WType_TopLevel | WDestructiveClose | WStyle_ContextHelp ),
      DCOPObject( "soundkonverter-app" )
{
    // this is our first startup, set instances to zero
    instances = 0;

    replayGainScanner = 0;
    cuesheetEditor = 0;
    logViewer = 0;

    device = "";
    visible = true;
    autoclose = false;
    configStartPage = ConfigDialog::GeneralPage;

    logger = new Logger();
    logger->log( 1000, "This is soundKonverter 0.3.7" );
    #ifdef HAVE_MP4V2
        logger->log( 1000, "MP4v2 is enabled" );
    #else
        logger->log( 1000, "MP4v2 is disabled" );
    #endif

    config = new Config( logger );
    config->read();

    // (re)move the 0.2 config file
    if( config->data.app.configVersion < 280 ) {
        KIO::rename( locateLocal("config","soundkonverterrc"), locateLocal("config","soundkonverterrc.back"), true );
//         KMessageBox::information( this, "You are using a pre-release of soundKonverter. This version is designed for testing only.\nThere are a few things not implemented at the moment but it should run without crashes and big problems. So feel free to report such an error if you find one.\nPlease have a look at the README.\n\nYour old configuration file has been moved to soundkonverterrc.back." );
    }
//     if( config->data.app.configVersion < 290 ) {
//         TQFile plugin_dir( locateLocal("data","soundkonverter/plugins") );
//         if( plugin_dir.exists() ) {
//             KIO::rename( locateLocal("data","soundkonverter/plugins"), locateLocal("data","soundkonverter/plugins.back"), true );
//             int ret = KMessageBox::questionYesNo( this, i18n("soundKonverter has cleaned up it's old installation. It seems to be necessary to restart soundKonverter!\n\nDo you want to restart soundKonverter now?") );
//             if( ret == KMessageBox::Yes ) {
//                 config->write();
//                 // TODO parameters are lost
//                 KProcess restart;
//                 restart << "soundkonverter";
//                 restart.start( KProcess::DontCare );
//                 kapp->quit();
//                 return;
//             }
//         }
//     }

    cdManager = new CDManager();
    tagEngine = new TagEngine();

    resize( 640, 470 );

    systemTray = new KSystemTray( this, "systemTray" );
    systemTray->hide();

    // create an icon loader object for loading icons
    KIconLoader *iconLoader = new KIconLoader();

    TQWidget* widget = new TQWidget( this, "widget" );
    setCentralWidget( widget );

    // NOTE created here because of some dependences
    options = new Options( config, i18n("Choose your prefered output options and click on \"Add files ...\"!"), widget, "options" );
    fileList = new FileList( cdManager, tagEngine, config, options, logger, widget, "fileList" );

    startAction = new KAction( i18n("&Start conversion"), "run", 0, TQT_TQOBJECT(fileList), TQT_SLOT(startConversion()), actionCollection(), "start" );
    startAction->setEnabled( false );
    new KAction( i18n("&Replay Gain Tool ..."), "soundkonverter_replaygain", CTRL+Key_R, TQT_TQOBJECT(this), TQT_SLOT(showReplayGainScanner()), actionCollection(), "replaygainscanner" );
    //new KAction( i18n("R&epair Tool ..."), "soundkonverter_repair", CTRL+Key_E, TQT_TQOBJECT(this), TQT_SLOT(showRepairTool()), actionCollection(), "repairtool" );
    new KAction( i18n("C&uesheet Editor ..."), "kwrite", CTRL+Key_U, TQT_TQOBJECT(this), TQT_SLOT(showCuesheetEditor()), actionCollection(), "cuesheeteditor" );
    new KAction( i18n("Show &Log ..."), "view_text", CTRL+Key_L, TQT_TQOBJECT(this), TQT_SLOT(showLogViewer()), actionCollection(), "log" );
//     new KAction( i18n("About &Plugins ..."), "connect_creating", CTRL+Key_P, TQT_TQOBJECT(this), TQT_SLOT(showAboutPlugins()), actionCollection(), "about_plugins" );

    stopAction = new KAction( i18n("S&top after current file is complete"), "stop", CTRL+Key_O, TQT_TQOBJECT(fileList), TQT_SLOT(stopConversion()), actionCollection(), "stop" );
    continueAction = new KAction( i18n("&Continue after current file is complete"), "run", CTRL+Key_T, TQT_TQOBJECT(fileList), TQT_SLOT(continueConversion()), actionCollection(), "continue" );
    killAction = new KAction( i18n("Stop &immediately"), "exit", CTRL+Key_K, TQT_TQOBJECT(fileList), TQT_SLOT(killConversion()), actionCollection(), "kill" );
    stopActionMenu = new KActionMenu( i18n("Stop"), "stop", actionCollection(), "stopMenu" );
    stopActionMenu->setDelayed( false );
    stopActionMenu->setEnabled( false );
//     stopActionMenu->insert( stopAction );
//     stopActionMenu->insert( continueAction );
//     stopActionMenu->insert( killAction );

/*    veryHighPriorityAction = new KToggleAction( i18n("Very hi&gh"), CTRL+Key_1, TQT_TQOBJECT(this), TQT_SLOT(priorityChanged()), actionCollection(), "veryhigh" );
    veryHighPriorityAction->setExclusiveGroup("priorityActionMenu");
    highPriorityAction = new KToggleAction( i18n("&High"), CTRL+Key_2, TQT_TQOBJECT(this), TQT_SLOT(priorityChanged()), actionCollection(), "high" );
    highPriorityAction->setExclusiveGroup("priorityActionMenu");
    normalPriorityAction = new KToggleAction( i18n("&Normal"), CTRL+Key_3, TQT_TQOBJECT(this), TQT_SLOT(priorityChanged()), actionCollection(), "nomal" );
    normalPriorityAction->setExclusiveGroup("priorityActionMenu");
    normalPriorityAction->setChecked(true);
    lowPriorityAction = new KToggleAction( i18n("&Low"), CTRL+Key_4, TQT_TQOBJECT(this), TQT_SLOT(priorityChanged()), actionCollection(), "low" );
    lowPriorityAction->setExclusiveGroup("priorityActionMenu");
    veryLowPriorityAction = new KToggleAction( i18n("Very lo&w"), CTRL+Key_5, TQT_TQOBJECT(this), TQT_SLOT(priorityChanged()), actionCollection(), "verylow" );
    veryLowPriorityAction->setExclusiveGroup("priorityActionMenu");
    priorityActionMenu = new KActionMenu( i18n("En-/Decoder priority"), "ksysguard", actionCollection(), "priorityMenu" );
    priorityActionMenu->setDelayed( false );
    priorityActionMenu->insert(veryHighPriorityAction);
    priorityActionMenu->insert(highPriorityAction);
    priorityActionMenu->insert(normalPriorityAction);
    priorityActionMenu->insert(lowPriorityAction);
    priorityActionMenu->insert(veryLowPriorityAction);*/
    //priorityChanged();

    new KAction( i18n("A&dd Files ..."), "sound", CTRL+Key_D, TQT_TQOBJECT(this), TQT_SLOT(showFileDialog()), actionCollection(), "add_files" );
    new KAction( i18n("Add &Folder ..."), "folder", CTRL+Key_F, TQT_TQOBJECT(this), TQT_SLOT(showDirDialog()), actionCollection(), "add_folder" );
    new KAction( i18n("Add CD &tracks ..."), "cdaudio_unmount", CTRL+Key_T, TQT_TQOBJECT(this), TQT_SLOT(showCdDialog()), actionCollection(), "add_audiocd" );
    new KAction( i18n("Add &URL ..."), "browser", CTRL+Key_U, TQT_TQOBJECT(this), TQT_SLOT(showUrlDialog()), actionCollection(), "add_url" );
    KStdAction::quit(TQT_TQOBJECT(this), TQT_SLOT(close()), actionCollection());

    new KAction( i18n("L&oad file list"), "fileopen", 0, TQT_TQOBJECT(fileList), TQT_SLOT(load()), actionCollection(), "load" );
    new KAction( i18n("Sa&ve file list"), "filesave", 0, TQT_TQOBJECT(fileList), TQT_SLOT(save()), actionCollection(), "save" );

    // TODO //KStdAction::paste( TQT_TQOBJECT(this), TQT_SLOT(pasteFiles()), actionCollection() );

    KStdAction::preferences( TQT_TQOBJECT(this), TQT_SLOT(showConfigDialog()), actionCollection() );

    showToolBarAction = KStdAction::showToolbar( TQT_TQOBJECT(this), TQT_SLOT(showToolbar()), actionCollection() );
    //KStdAction::showStatusbar( 0, 0, actionCollection() );
    KStdAction::configureToolbars( TQT_TQOBJECT(this), TQT_SLOT(editToolbar()), actionCollection() );

    createGUI();

    if( config->data.general.showToolBar ) {
        toolBar()->show();
        showToolBarAction->setChecked( true );
    }
    else {
        toolBar()->hide();
        showToolBarAction->setChecked( false );
    }

    // the grid for all widgets in the main window
    TQGridLayout* gridLayout = new TQGridLayout( widget, 1, 1, 6, 6, "gridLayout" );

    // generate the options input area
    // NOTE created above because of some dependences
    //options = new Options( config, i18n("Choose your prefered output options and click on \"Add files ...\"!"), this, "options" );
    connect( options, TQT_SIGNAL(showConfigPluginsPage()),
               TQT_TQOBJECT(this), TQT_SLOT(showConfigPluginsPage())
             );
    connect( options, TQT_SIGNAL(showConfigEnvironmentPage()),
               TQT_TQOBJECT(this), TQT_SLOT(showConfigEnvironmentPage())
             );
    gridLayout->addWidget( options, 0, 0 );

    // generate the list view for the file list
    // NOTE created above because of some dependences
    //fileList = new FileList( cdManager, tagEngine, config, options, this, "fileList" );
    gridLayout->addWidget( fileList, 1, 0 );
    gridLayout->setRowStretch( 1, 1 );
    /*connect( TQT_TQOBJECT(this), TQT_SIGNAL(windowMoved(int,int)),
               TQT_TQOBJECT(fileList), TQT_SLOT(moveOptionsEditor(int,int))
             );*/
    connect( TQT_TQOBJECT(fileList), TQT_SIGNAL(fileCountChanged(int)),
               TQT_TQOBJECT(this), TQT_SLOT(fileCountChanged(int))
             );
    connect( TQT_TQOBJECT(fileList), TQT_SIGNAL(startedConversion()),
               TQT_TQOBJECT(this), TQT_SLOT(startedConversion())
             );
    connect( TQT_TQOBJECT(fileList), TQT_SIGNAL(stopClicked()),
               TQT_TQOBJECT(this), TQT_SLOT(stopClicked())
             );
    connect( TQT_TQOBJECT(fileList), TQT_SIGNAL(continueClicked()),
               TQT_TQOBJECT(this), TQT_SLOT(continueClicked())
             );
    connect( TQT_TQOBJECT(fileList), TQT_SIGNAL(stoppedConversion()),
               TQT_TQOBJECT(this), TQT_SLOT(stoppedConversion())
             );

    convert = new Convert( config, tagEngine, cdManager, fileList, logger );
//     connect( TQT_TQOBJECT(this), TQT_SIGNAL(setPriority(int)),
//                convert, TQT_SLOT(priorityChanged(int))
//              );

    // add a horizontal box layout for the add combobutton to the grid
    TQHBoxLayout *addBox = new TQHBoxLayout( -1, "addBox" );
    gridLayout->addLayout( addBox, 2, 0 );

    // create the combobutton for adding files to the file list
    cAdd = new ComboButton( widget, "cAdd" );
    TQFont font = cAdd->font();
    //font.setWeight( TQFont::DemiBold );
    font.setPointSize( font.pointSize() + 1 );
    cAdd->setFont( font );
    cAdd->insertItem( iconLoader->loadIcon("sound",KIcon::Toolbar), i18n("Add files ...") );
    cAdd->insertItem( iconLoader->loadIcon("folder",KIcon::Toolbar), i18n("Add folder ...") );
    cAdd->insertItem( iconLoader->loadIcon("cdaudio_unmount",KIcon::Toolbar), i18n("Add CD tracks ...") );
    cAdd->insertItem( iconLoader->loadIcon("browser",KIcon::Toolbar), i18n("Add URL ...") );
    addBox->addWidget( cAdd );
    connect( cAdd, TQT_SIGNAL(clicked(int)),
             TQT_TQOBJECT(this), TQT_SLOT(addClicked(int))
           );

    addBox->addSpacing( 18 );

    pStart = new KPushButton( iconLoader->loadIcon("run",KIcon::Small), i18n("Start"), widget, "pStart" );
    pStart->setFixedHeight( pStart->size().height() );
    pStart->setEnabled( false );
    addBox->addWidget( pStart );
    connect( pStart, TQT_SIGNAL(clicked()),
               TQT_TQOBJECT(fileList), TQT_SLOT(startConversion())
             );

    pStop = new KPushButton( iconLoader->loadIcon("stop",KIcon::Small), i18n("Stop"), widget, "pStop" );
    pStop->setFixedHeight( pStop->size().height() );
    pStop->hide();
    pStop->setPopup( stopActionMenu->popupMenu() );
    addBox->addWidget( pStop );

    addBox->addSpacing( 8 );

    progressIndicator = new ProgressIndicator( systemTray, widget, "progressIndicator" );
    addBox->addWidget( progressIndicator );
    connect( TQT_TQOBJECT(fileList), TQT_SIGNAL(increaseTime(float)),
               progressIndicator, TQT_SLOT(increaseTime(float))
             );
    connect( TQT_TQOBJECT(fileList), TQT_SIGNAL(decreaseTime(float)),
               progressIndicator, TQT_SLOT(decreaseTime(float))
             );
    /*connect( TQT_TQOBJECT(fileList), TQT_SIGNAL(setTime(float)),
               progressIndicator, TQT_SLOT(setTime(float))
             );*/
    connect( TQT_TQOBJECT(fileList), TQT_SIGNAL(finished(float)),
               progressIndicator, TQT_SLOT(finished(float))
             );
    connect( convert, TQT_SIGNAL(countTime(float)),
               progressIndicator, TQT_SLOT(countTime(float))
             );
    connect( convert, TQT_SIGNAL(uncountTime(float)),
               progressIndicator, TQT_SLOT(uncountTime(float))
             );
    connect( convert, TQT_SIGNAL(update(float)),
               progressIndicator, TQT_SLOT(update(float))
             );
    connect( progressIndicator, TQT_SIGNAL(setTitle(const TQString&)),
               TQT_TQOBJECT(this), TQT_SLOT(setTitle(const TQString&))
             );

    cAdd->increaseHeight( /*progressIndicator->height() - cAdd->height()*/ 10 ); // FIXME detect the height automaticly
    cAdd->adjustSize();

    // delete the icon loader object
    delete iconLoader;

    fileList->load( true ); // restore file list after a crash
}

soundKonverter::~soundKonverter()
{
    // TODO clean tmp dir (stop all running processes)
    delete replayGainScanner;
    delete cuesheetEditor;
    delete logViewer;
}

void soundKonverter::increaseInstances()
{
    // a new instance should be created, so this isn't the initial startup no longer
    instances++;
}

bool soundKonverter::queryClose()
{
    config->removeProfile( i18n("Last used") );
    config->addProfile( i18n("Last used"), options->getCurrentOptions() );

    config->write( false );

    convert->cleanUp();
    logger->cleanUp();

    TQFile::remove( locateLocal("data","soundkonverter/filelist.autosave.xml") );

    return true;
}

void soundKonverter::setNotify( const TQString& cmd )
{
    fileList->setNotify( cmd );
}

/*void soundKonverter::moveEvent( TQMoveEvent* e )
{
//    emit windowMoved( pos().x(), pos().y() + height() );
}*/

void soundKonverter::openArgFiles( const TQStringList &files )
{
    if( ( instances <= 1 || config->data.general.askForNewOptions ) && ( profile == "" || format == "" || directory == "" ) )
    {
        OptionsRequester* dialog = new OptionsRequester( config, files, this );

        connect( dialog, TQT_SIGNAL(setCurrentOptions(const ConversionOptions&)),
                   options, TQT_SLOT(setCurrentOptions(const ConversionOptions&))
                 );
        connect( dialog, TQT_SIGNAL(addFiles(TQStringList)),
                   TQT_TQOBJECT(fileList), TQT_SLOT(addFiles(TQStringList))
                 );

        Q_CHECK_PTR( dialog );

        if( profile != "" ) {
            dialog->setProfile( profile );
            profile = "";
        }
        if( format != "" ) {
            dialog->setFormat( format );
            format = "";
        }
        if( directory != "" ) {
            dialog->setOutputDirectory( directory );
            directory = "";
        }

        dialog->exec();

        disconnect( dialog, TQT_SIGNAL(setCurrentOptions(const ConversionOptions&)), 0, 0 );
        disconnect( dialog, TQT_SIGNAL(addFiles(TQStringList)), 0, 0 );

        delete dialog;
    }
    else
    {
        ConversionOptions conversionOptions = options->getCurrentOptions();

        if( profile != "" ) {
            options->setProfile( profile );
            profile = "";
        }
        if( format != "" ) {
            options->setFormat( format );
            format = "";
        }
        if( directory != "" ) {
            options->setOutputDirectory( directory );
            directory = "";
        }
        fileList->addFiles( files );

        options->setCurrentOptions( conversionOptions );
    }

    if( !visible ) fileList->startConversion(); // NOTE should be save!
}

void soundKonverter::openArgReplayGainFiles( const TQStringList &files )
{
    showReplayGainScanner();
    if( replayGainScanner ) replayGainScanner->addFiles( files );
}

// void soundKonverter::openArgRepairFiles( const TQStringList &files )
// {}

void soundKonverter::startedConversion()
{
    pStart->hide();
    if( fileList->queueEnabled() )
    {
        startAction->setEnabled( false );
        startAction->setText( i18n("&Start conversion") );
        stopActionMenu->remove( startAction );
        stopActionMenu->remove( stopAction );
        stopActionMenu->remove( continueAction );
        stopActionMenu->remove( killAction );
        stopActionMenu->insert( stopAction );
        stopActionMenu->insert( continueAction );
        stopActionMenu->insert( killAction );
    }
    else
    {
        startAction->setEnabled( true );
        startAction->setText( i18n("&Start queue") );
        stopActionMenu->remove( startAction );
        stopActionMenu->remove( stopAction );
        stopActionMenu->remove( continueAction );
        stopActionMenu->remove( killAction );
        stopActionMenu->insert( killAction );
        stopActionMenu->insert( startAction );
    }
    pStop->show();
    stopActionMenu->setEnabled( true );
    stopAction->setEnabled( true );
    continueAction->setEnabled( false );
    killAction->setEnabled( true );
}

void soundKonverter::stopClicked()
{
    stopAction->setEnabled( false );
    continueAction->setEnabled( true );
}

void soundKonverter::continueClicked()
{
    stopAction->setEnabled( true );
    continueAction->setEnabled( false );
}

void soundKonverter::stoppedConversion()
{
    pStart->show();
    startAction->setEnabled( true );
    startAction->setText( i18n("&Start conversion") );
    pStop->hide();
    stopActionMenu->setEnabled( false );

    if( autoclose ) kapp->quit(); // NOTE close app on conversion stop (may irritate the user when stopping the conversion)
}

// void soundKonverter::priorityChanged()
// {
//     int priority = 0;
// 
//     //if( veryHighPriorityAction->isChecked() ) priority=-19;
//     //else if( highPriorityAction->isChecked() ) priority=-10;
//     if( lowPriorityAction->isChecked() ) priority = 10;
//     else if( veryLowPriorityAction->isChecked() ) priority = 20;
// 
//     emit setPriority( priority );
// }

void soundKonverter::addClicked( int index )
{
    fileList->save( true );

    if( index == 0 ) {
         showFileDialog();
    }
    else if( index == 1 ) {
         showDirDialog();
    }
    else if( index == 2 ) {
         showCdDialog( true );
    }
    else {
         showUrlDialog();
    }

    fileList->save( true );
}

void soundKonverter::showFileDialog()
{
    TQStringList urls = KFileDialog::getOpenURLs( ":file_open", config->fileFilter(), this, i18n("Choose files to convert") ).toStringList();
    if( !urls.empty() ) {
/*        for( TQStringList::Iterator it = urls.begin(); it != urls.end(); ++it ) {
            *it = KURL::decode_string( *it );
        }*/
        fileList->addFiles( urls );
    }
}

void soundKonverter::showDirDialog()
{
//     TQString directory = KFileDialog::getExistingDirectory( ":file_open", this, i18n("Choose a directory") );
//     if( !directory.isEmpty() )
//     {
//         fileList->addDir( directory );
//     }

    DirDialog *dialog = new DirDialog( config, DirDialog::Convert, this, "DirDialog" );

    Q_CHECK_PTR( dialog );

    if( dialog->exec() ) {
        fileList->addDir( dialog->directory, dialog->selectedFileTypes, dialog->recursive );
    }

    delete dialog;
}

void soundKonverter::showCdDialog( bool intern )
{
    ConversionOptions conversionOptions = options->getCurrentOptions();

    if( ( instances <= 1 || config->data.general.askForNewOptions ) && ( profile == "" || format == "" || directory == "" ) && !intern )
    {
        OptionsRequester* dialog = new OptionsRequester( config, "", this );

        connect( dialog, TQT_SIGNAL(setCurrentOptions(const ConversionOptions&)),
                   options, TQT_SLOT(setCurrentOptions(const ConversionOptions&))
                 );
//         connect( dialog, TQT_SIGNAL(addFiles(TQStringList)),
//                    TQT_TQOBJECT(fileList), TQT_SLOT(addFiles(TQStringList))
//                  );

        Q_CHECK_PTR( dialog );

        if( profile != "" ) {
            dialog->setProfile( profile );
            profile = "";
        }
        if( format != "" ) {
            dialog->setFormat( format );
            format = "";
        }
        if( directory != "" ) {
            dialog->setOutputDirectory( directory );
            directory = "";
        }

        dialog->exec();

        disconnect( dialog, TQT_SIGNAL(setCurrentOptions(const ConversionOptions&)), 0, 0 );
//         disconnect( dialog, TQT_SIGNAL(addFiles(TQStringList)), 0, 0 );

        delete dialog;
    }
    else
    {
        if( profile != "" ) {
            options->setProfile( profile );
            profile = "";
        }
        if( format != "" ) {
            options->setFormat( format );
            format = "";
        }
        if( directory != "" ) {
            options->setOutputDirectory( directory );
            directory = "";
        }
    }

    // support for media:/ and system:/ urls
    if( !device.isEmpty() ) {
        device.replace( "system:/media", "/dev" );
        device.replace( "media:", "/dev" );
        device.replace( "devices:", "/dev" ); // NOTE obsolete, since soundkonverter 0.3 won't run on KDE < 3.5
    }
    if( device.left(5) != "/dev/" || device == "auto" ) {
        device = "";
    }

    kapp->eventLoop()->exitLoop();

    // create a new CDOpener object for letting the user add some tracks from a CD
    CDOpener *dialog = new CDOpener( config, cdManager, tagEngine, device, this, "CDOpener" );

    device = "";

    Q_CHECK_PTR( dialog );

    if( !dialog->noCD )
    {
        connect( dialog, TQT_SIGNAL(addTracks(const TQString&,TQValueList<int>)),
                TQT_TQOBJECT(fileList), TQT_SLOT(addTracks(const TQString&,TQValueList<int>))
                );
        connect( dialog, TQT_SIGNAL(addDisc(const TQString&)),
                TQT_TQOBJECT(fileList), TQT_SLOT(addDisc(const TQString&))
                );
        /*connect( dialog, TQT_SIGNAL(openCuesheetEditor(const TQString&)),
                TQT_TQOBJECT(this), TQT_SLOT(openCuesheetEditor(const TQString&))
                );*/

        dialog->exec();

        disconnect( dialog, TQT_SIGNAL(addTracks(const TQString&,TQValueList<int>)), 0, 0 );
        disconnect( dialog, TQT_SIGNAL(addDisc(const TQString&)), 0, 0 );
        //disconnect( dialog, TQT_SIGNAL(openCuesheetEditor(const TQString&)), 0, 0 );
    }
    delete dialog;

    kapp->eventLoop()->enterLoop();

    options->setCurrentOptions( conversionOptions );
}

void soundKonverter::showUrlDialog()
{
    bool ok;
    TQString url = KInputDialog::getText( i18n("Open URL"), i18n("Enter a URL:"), "", &ok );
    if( ok )
    {
        // if it isn't a local file and no protocol is given, we assume, it's http
        if( url.left(1) != "/" && !url.contains(":/") )
            url.prepend( "http://" );

        fileList->addFiles( url );
    }
}

void soundKonverter::showReplayGainScanner()
{
    if( replayGainScanner == 0 ) {
        replayGainScanner = new ReplayGainScanner( tagEngine, config, logger, 0, "replayGainScanner", false );
        if( replayGainScanner == 0 ) {
            // TODO error message
            return;
        }
//         connect( TQT_TQOBJECT(this), TQT_SIGNAL(addFilesToReplayGainScanner(TQStringList)),
//                    replayGainScanner, TQT_SLOT(addFiles(TQStringList))
//                  );
    }
    replayGainScanner->show();
    replayGainScanner->raise();
}

void soundKonverter::showRepairTool()
{}

void soundKonverter::showCuesheetEditor()
{
    if( cuesheetEditor == 0 ) {
        cuesheetEditor = new CuesheetEditor( 0, "cuesheetEditor", false );
        if( cuesheetEditor == 0 ) {
            // TODO error message
            return;
        }
    }
    cuesheetEditor->show();
    cuesheetEditor->raise();
}

/*void soundKonverter::openCuesheetEditor( const TQString& content )
{
    if( cuesheetEditor == 0 ) {
        cuesheetEditor = new CuesheetEditor( 0, "cuesheetEditor", false );
        if( cuesheetEditor == 0 ) {
            // TODO error message
            return;
        }
    }
    cuesheetEditor->setContent( content );
    cuesheetEditor->show();
}*/

void soundKonverter::showLogViewer()
{
    if( logViewer == 0 ) {
        logViewer = new LogViewer( logger, 0, "logViewer", false );
        if( logViewer == 0 ) {
            // TODO error message
            return;
        }
//         connect( convert, TQT_SIGNAL(finishedProcess(int,int)),
//                    logViewer, TQT_SLOT(processCompleted(int,int))
//                  );
    }
    logViewer->show();
    logViewer->raise();
}

void soundKonverter::showConfigDialog()
{
    ConfigDialog *dialog = new ConfigDialog( config, this, "ConfigDialog", ConfigDialog::Page(configStartPage) );

    Q_CHECK_PTR( dialog );

    //dialog->setGeometry( frameGeometry() );
    dialog->resize( size() );

    dialog->exec();

    delete dialog;

    configStartPage = ConfigDialog::GeneralPage;
}

void soundKonverter::showConfigPluginsPage()
{
    configStartPage = ConfigDialog::PluginsPage;
    showConfigDialog();
}

void soundKonverter::showConfigEnvironmentPage()
{
    configStartPage = ConfigDialog::EnvironmentPage;
    showConfigDialog();
}

// void soundKonverter::showAboutPlugins()
// {
//     AboutPlugins *dialog = new AboutPlugins( config, this, "AboutPlugins" );
// 
//     Q_CHECK_PTR( dialog );
// 
//     dialog->exec();
// 
//     delete dialog;
// }

void soundKonverter::showToolbar()
{
    if( showToolBarAction->isChecked() ) {
        toolBar()->show();
        config->data.general.showToolBar = true;
    }
    else {
        toolBar()->hide();
        config->data.general.showToolBar = false;
    }
}

void soundKonverter::editToolbar()
{
    saveMainWindowSettings( kapp->config(), "MainWindow" );
    KEditToolbar dlg( actionCollection() );
    connect( &dlg, TQT_SIGNAL(newToolbarConfig()),
               TQT_TQOBJECT(this), TQT_SLOT(newToolbarConfig())
             );
    dlg.exec();
}

void soundKonverter::newToolbarConfig()
{
    createGUI();
    applyMainWindowSettings( kapp->config(), "MainWindow" );
}

void soundKonverter::fileCountChanged( int count )
{
    if( count > 0 ) {
        startAction->setEnabled( true );
        pStart->setEnabled( true );
    }
    else {
        startAction->setEnabled( false );
        pStart->setEnabled( false );
    }
}

void soundKonverter::setTitle( const TQString& title )
{
    setCaption( title );
}


#include "soundkonverter.moc"
