

#ifndef PROGRESSINDICATOR_H
#define PROGRESSINDICATOR_H

#include <tqwidget.h>
#include <tqdatetime.h>

class TQProgressBar;
class TQLabel;
class KSystemTray;

/**
 * @short Displays the current progress
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ProgressIndicator : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT
public:
    /**
     * Constructor
     */
    ProgressIndicator( KSystemTray* _systemTray, TQWidget* parent = 0, const char* name = 0 );

    /**
     * Destructor
     */
    virtual ~ProgressIndicator();

public slots:
    void increaseTime( float );
    void decreaseTime( float );
    void countTime( float );
    void uncountTime( float );
    void setTime( float );
    void finished( float );

    void update( float );

//private slots:

private:
    TQProgressBar* pBar;
    TQLabel* lSpeed;
    TQLabel* lTime;
    KSystemTray* systemTray;

    TQTime elapsedTime;
    TQTime speedTime;
    float speedProcessedTime;

    float time;
    float processedTime;

signals:
    void setTitle( const TQString& );
};

#endif // PROGRESSINDICATOR_H
