
#include "progressindicator.h"

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqprogressbar.h>
#include <tqtooltip.h>

#include <klocale.h>
#include <ksystemtray.h>
//#include <kiconloader.h>
//#include <kmessagebox.h>
// #include <kdebug.h>


ProgressIndicator::ProgressIndicator( KSystemTray* _systemTray, TQWidget* parent, const char* name )
    : TQWidget( parent, name )
{
    systemTray = _systemTray;

    time = processedTime = 0;

    TQGridLayout *grid = new TQGridLayout( this, 1, 1, 0, 6, "grid" );

    TQHBoxLayout *box = new TQHBoxLayout( );
    grid->addLayout( box, 0, 0 );

    pBar = new TQProgressBar( this, "pBar" );
    box->addWidget( pBar );

    TQGridLayout *statusChildGrid = new TQGridLayout( box, 2, 2, 6, "statusChildGrid" );

    TQLabel *lSpeedText = new TQLabel( i18n("Speed")+":", this, "lSpeedText" );
    statusChildGrid->addWidget( lSpeedText, 0, 0, TQt::AlignVCenter );

    lSpeed = new TQLabel( "0.0x", this, "lSpeed" );
    lSpeed->setFont( TQFont( "Courier" ) );
    statusChildGrid->addWidget( lSpeed, 0, 1, TQt::AlignVCenter | TQt::AlignRight );
    speedTime.setHMS( 24, 0, 0 );

    TQLabel *lTimeText = new TQLabel( i18n("Time remaining")+":", this, "lTimeText" );
    statusChildGrid->addWidget( lTimeText, 1, 0, TQt::AlignVCenter );

    lTime = new TQLabel( "00:00", this, "lTime" );
    lTime->setFont( TQFont( "Courier" ) );
    statusChildGrid->addWidget( lTime, 1, 1, TQt::AlignVCenter | TQt::AlignRight );
    elapsedTime.setHMS( 24, 0, 0 );

    TQToolTip::add( systemTray, i18n("Waiting") );
}

ProgressIndicator::~ProgressIndicator()
{}

void ProgressIndicator::increaseTime( float t )
{
    time += t;
//     kdDebug() << "increaseTime: " << time << " (" << t  << ")" <<  endl;
}

void ProgressIndicator::decreaseTime( float t )
{
    time -= t;
//     kdDebug() << "decreaseTime: " << time << " (" << t  << ")" <<  endl;
}

void ProgressIndicator::countTime( float t )
{
    processedTime += t;
//     kdDebug() << "countTime: " << processedTime << " (" << t  << ")" <<  endl;
}

void ProgressIndicator::uncountTime( float t )
{
    processedTime -= t;
//     kdDebug() << "uncountTime: " << processedTime << " (" << t  << ")" <<  endl;
}

void ProgressIndicator::setTime( float t )
{
    time = t;
//     kdDebug() << "setTime: " << time << " (" << t  << ")" <<  endl;
}

void ProgressIndicator::finished( float t )
{
    time = t;
//     kdDebug() << "finished: " << time << " (" << t  << ")" <<  endl;
    processedTime = 0;
    pBar->setProgress( 100, 100 );
    elapsedTime.setHMS( 24, 0, 0 );
    lTime->setText( "00:00" );
    speedTime.setHMS( 24, 0, 0 );
    lSpeed->setText( "0.0x" );
    TQToolTip::add( systemTray, i18n("Finished") );
    emit setTitle( i18n("Finished") );
}

void ProgressIndicator::update( float t )
{
//     kdDebug() << "update: " << (processedTime + t) << " / " << time  << endl;
    pBar->setProgress( int(processedTime + t), int(time) );
    float fPercent;
//     if( pBar->totalSteps() > 0 ) fPercent = pBar->progress() * 100 / pBar->totalSteps();
    if( pBar->totalSteps() > 0 ) fPercent = (processedTime+t)*100.0f / time;
    else fPercent = 0.1f;

    if( !elapsedTime.isValid() ) elapsedTime.start();
    if( !speedTime.isValid() ) speedTime.start();
    if( speedTime.elapsed() > 1000 ) {
        if( elapsedTime.elapsed() > 10000 ) {
//             int tim = (int)( 1 + ((100/fPercent)-1) * (elapsedTime.elapsed()/1000) );
            int tim = (int)(( 1.0f + ((100.0f/fPercent)-1.0f) * (elapsedTime.elapsed()/1000.0f) ));
            //float fPercent = pBar->progress() / pBar->totalSteps();
            //int tim = (int)( 1 + (elapsedTime.elapsed()/fPercent - elapsedTime.elapsed()) / 1000 );
            if( tim >= 0 && tim < 1000000 ) {
                int sec = tim % 60;
                int min = ( tim / 60 ) % 60;
                int hou = tim / 3600;
                TQString timeLeft;
                if( hou > 0 )
                    timeLeft.sprintf( "%d:%02d:%02d", hou, min, sec );
                else
                    timeLeft.sprintf( "%02d:%02d", min, sec );
                lTime->setText( timeLeft );
            }
        }

        int tim = speedTime.restart() / 1000;
        float speed = ( processedTime + t - speedProcessedTime ) / tim;
        speedProcessedTime = processedTime + t;
        if( speed >= 0.0f && speed < 100000.0f ) {
            TQString actSpeed;
            actSpeed.sprintf( "%.1fx", speed );
            lSpeed->setText( actSpeed );
        }
    }

    TQString percent;
    percent.sprintf( "%i%%", (int)fPercent );
    emit setTitle( percent );
    TQToolTip::add( systemTray, percent );
}

