

#ifndef RIPPERPLUGINLOADER_H
#define RIPPERPLUGINLOADER_H

#include "pluginloaderbase.h"


/**
 * @short The complete data, how to use the backend
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class RipperPlugin
{
public:
    /**
     * Constructor
     */
    RipperPlugin();

    /**
     * Destructor
     */
    virtual ~RipperPlugin();

    TQString filePathName; // the file name of th plugin (needed to detect write permissions)

    struct Info
    {
        int version;    // the version of our plugin (v0.2.1 = 201, v11.3 = 110300)
        TQString name;   // the name of our plugin
        TQString author; // the author of the plugin
        TQString about;  // a short information aboue the plugin
    } info;

    struct Rip
    {
        //PluginLoaderBase::FeatureLevel level;
        int rank;
        TQString bin;
        TQString param;
        TQString silent_param;
        TQString out_file;
        TQString track;
        TQString device;
        TQString overwrite;
        TQString output;

        struct FullDisc
        {
            bool enabled;
            TQString param;
            TQString output;
        } full_disc;
    } rip;
};

/**
 * @short The plugin loader for the ripper plugins
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class RipperPluginLoader : public PluginLoaderBase
{
    Q_OBJECT
  TQ_OBJECT
public:
    /**
     * Constructor
     */
    RipperPluginLoader();

    /**
     * Destructor
     */
    virtual ~RipperPluginLoader();

    /** is this file a ripper plugin and loadable? */
    int verifyFile( TQString );
    /** load a given file */
    RipperPlugin* loadFile( TQString );
};

#endif // RIPPERPLUGINLOADER_H
