
#include "formatinfoloader.h"

#include <tqfile.h>

#include <klocale.h>
#include <kglobal.h>

FormatInfo::FormatInfo()
{}

FormatInfo::~FormatInfo()
{}


FormatInfoLoader::FormatInfoLoader()
{}

FormatInfoLoader::~FormatInfoLoader()
{}

bool FormatInfoLoader::verifyFile( TQString fileName )
{
    TQFile opmlFile( fileName );
    if( !opmlFile.open( IO_ReadOnly ) ) {
        return false;
    }
    if( !domTree.setContent( &opmlFile ) ) {
        return false;
    }
    opmlFile.close();

    TQDomElement root = domTree.documentElement();
    if( root.attribute("type") == "format_info" ) return true;

    return false;
}

FormatInfo* FormatInfoLoader::loadFile( TQString fileName )
{
    int t_int;
    float t_float;
    TQString t_str;

    FormatInfo* plugin = new FormatInfo();
    plugin->mime_types = "application/octet-stream"; // if something goes wrong, we can see that by looking at plugin->mimetype

    TQFile opmlFile( fileName );
    if( !opmlFile.open( IO_ReadOnly ) ) {
        return plugin;
    }
    if( !domTree.setContent( &opmlFile ) ) {
        return plugin;
    }
    opmlFile.close();

    TQString language = KGlobal::locale()->languagesTwoAlpha().first();

    TQDomElement root = domTree.documentElement();
    if( root.attribute("type") != "format_info" ) return plugin;
    TQDomNode node;
    node = root.firstChild();

    while( !node.isNull() ) {
        if( node.isElement() && node.nodeName() == "data" ) {

            plugin->mime_types = TQStringList::split( ',',node.toElement().attribute("mime_types","application/octet-stream") );
            plugin->extensions = TQStringList::split( ',',node.toElement().attribute("extensions") );
            plugin->description = node.toElement().attribute("description_"+language);
            if( plugin->description.isEmpty() ) plugin->description = node.toElement().attribute("description");
            plugin->urls = TQStringList::split( ',',node.toElement().attribute("urls_"+language) );
            if( plugin->urls.isEmpty() ) plugin->urls = TQStringList::split( ',',node.toElement().attribute("urls") );
            TQStringList compressionTypeList = TQStringList::split( ',',node.toElement().attribute("compression_type") );
            plugin->compressionType = (FormatInfo::CompressionType)0x0000;
            for( TQStringList::Iterator it = compressionTypeList.begin(); it != compressionTypeList.end(); ++it ) {
                if( *it == "lossy" ) plugin->compressionType = FormatInfo::CompressionType( plugin->compressionType | FormatInfo::lossy );
                else if( *it == "lossless" ) plugin->compressionType = FormatInfo::CompressionType( plugin->compressionType | FormatInfo::lossless );
                else if( *it == "hybrid" ) plugin->compressionType = FormatInfo::CompressionType( plugin->compressionType | FormatInfo::hybrid );
            }
            plugin->size = node.toElement().attribute("size","15000").toInt();

        }
        node = node.nextSibling();
    }

    return plugin;
}

