

#ifndef OPTIONSSIMPLE_H
#define OPTIONSSIMPLE_H

#include "outputdirectory.h"
#include "conversionoptions.h"

#include <tqwidget.h>

class Config;
class ConversionOptions;
class OptionsDetailed;

class KComboBox;
class KToolBarButton;
class KPushButton;

/**
 * @short The options widget for setting up the output options very easy
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class OptionsSimple : public TQWidget
{
    Q_OBJECT
  TQ_OBJECT
public:
    /**
     * Constructor
     */
    OptionsSimple( Config*, OptionsDetailed*, const TQString &text, TQWidget* parent=0, const char* name=0 );

    /**
     * Detructor
     */
    virtual ~OptionsSimple();

    /**
     * Set the current options
     */
//     void setCurrentOptions( const ConversionOptions& );

    /**
     * Refills the whole form (e.g. after a config change)
     */
    void refill(); // TODO syncronize with optionsDetailed

    void setCurrentProfile( const TQString& profile );
    void setCurrentFormat( const TQString& format );
    void setCurrentOutputDirectory( const TQString& directory );

private:
    KComboBox* cProfile;
    KPushButton* pProfileRemove;
    KPushButton* pProfileInfo;
    KComboBox* cFormat;
    KPushButton* pFormatInfo;

    OutputDirectory* outputDirectory;

    Config* config;
    OptionsDetailed* optionsDetailed;

    TQStringList sProfile;
    TQStringList sFormat;

    int profileIndex( const TQString& string );
    int formatIndex( const TQString& string );

//public slots:
//    void setProfile( const TQString &profile );
//    void setFormat( const TQString &format );

private slots:
    void profileInfo();
    void profileRemove();
    void formatInfo();
    void profileChanged();
    void formatChanged();
    void outputDirectoryModeChanged( OutputDirectory::Mode );
    void outputDirectoryPathChanged( const TQString& );

    void somethingChanged();

signals:
//     void setFormat( const TQString& format );
//     void setQualityMode( const TQString& qualityMode );
//     void setQuality( int quality );
//     void setBitrateMode( const TQString& bitrateMode );
//     void setBitrateRangeEnabled( bool enabled );
//     void setMinBitrate( int bitrate );
//     void setMaxBitrate( int bitrate );
//     void setSamplingrateEnabled( bool enabled );
//     void setSamplingrate( int sampleRate );
//     void setSamplingrate( const TQString& sampleRate );
//     void setChannelsEnabled( bool enabled );
//     void setChannels( const TQString& channels );
//     void setReplayGainEnabled( bool enabled );
//     void setOutputDirectoryMode( OutputDirectory::Mode );
//     void setOutputDirectoryPath( const TQString& directory );
//     void setOptions( const ConversionOptions& options );
//     void setUserOptions( const TQString& options );

    void optionsChanged();
};

#endif
