

#ifndef OPTIONSREQUESTER_H
#define OPTIONSREQUESTER_H

#include <kdialog.h>

#include "conversionoptions.h"

class Options;
class Config;
class TQStringList;
class KPushButton;

/**
 * @short Shows an input dialog for selecting conversion options
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class OptionsRequester : public KDialog
{
    Q_OBJECT
  TQ_OBJECT
public:
    /**
     * Default Constructor
     */
    OptionsRequester( Config*, TQStringList list, TQWidget *parent=0, const char *name=0, bool modal=true, WFlags f=0 );

    /**
     * Default Destructor
     */
    virtual ~OptionsRequester();

    void setProfile( const TQString& profile );
    void setFormat( const TQString& format );
    void setOutputDirectory( const TQString& directory );

private slots:
    void okClicked();

signals:
    void setCurrentOptions( const ConversionOptions& );
    void addFiles( TQStringList );

private:
    KPushButton* pOk;
    KPushButton* pCancel;
    TQStringList files;

    Options* options;
};

#endif // OPTIONSREQUESTER_H

