
#include "optionsrequester.h"
#include "options.h"
#include "config.h"

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqstringlist.h>

#include <klocale.h>
#include <kpushbutton.h>
#include <kiconloader.h>


OptionsRequester::OptionsRequester( Config* config, TQStringList list, TQWidget *parent, const char *name, bool modal, WFlags f )
    : KDialog( parent, name, modal, f )
{
    setCaption( i18n("Choose output options") );

    files = list;
    int row = 1;

    // create an icon loader object for loading icons
    KIconLoader* iconLoader = new KIconLoader();

    TQGridLayout *grid = new TQGridLayout( this, 2, 1, 11, 6 );

    options = new Options( config, i18n("Click on \"Ok\" to add the files to the list in the main window!"), this, "options" );
    grid->addWidget( options, 0, 0 );

    TQStringList::Iterator it = files.begin();
    while( it != files.end() )
    {
        TQString sFormat = *it;
        int i = sFormat.findRev( '.' );
        sFormat.remove( 0, i + 1 );
        sFormat.lower();

        if( sFormat == "wav" ) // FIXME use mime types
        {
            TQHBoxLayout *warningBox = new TQHBoxLayout();
            grid->addLayout( warningBox, 1, 0 );
            TQLabel* lWarning = new TQLabel( i18n("Warning: If you select \"wav\" as output format, your wav files will not be added to the list."), this, "lWarning" );
            warningBox->addWidget( lWarning );
            row++;
            break;
        }
        it++;
    }

    TQHBoxLayout* buttonBox = new TQHBoxLayout();
    grid->addLayout( buttonBox, row, 0 );

    buttonBox->addStretch();

    pCancel = new KPushButton( iconLoader->loadIcon("exit",KIcon::Small), i18n("Cancel"), this, "pCancel" );
    buttonBox->addWidget( pCancel );

    pOk = new KPushButton( iconLoader->loadIcon("apply",KIcon::Small), i18n("Ok"), this, "pOk" );
    buttonBox->addWidget( pOk );

    connect( pCancel, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(reject())
             );
    connect( pOk, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(okClicked())
             );

    // delete the icon loader object
    delete iconLoader;
}

OptionsRequester::~OptionsRequester()
{}

void OptionsRequester::okClicked()
{
    emit setCurrentOptions( options->getCurrentOptions() );
    emit addFiles( files );
    accept();
}

void OptionsRequester::setProfile( const TQString& profile )
{
    options->setProfile( profile );
}

void OptionsRequester::setFormat( const TQString& format )
{
    options->setFormat( format );
}

void OptionsRequester::setOutputDirectory( const TQString& directory )
{
    options->setOutputDirectory( directory );
}


