

#ifndef LOGVIEWER_H
#define LOGVIEWER_H

#include <klistview.h>
#include <kdialog.h>


class KPushButton;
class Logger;

/**
 * @short The items for the log viewer list
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class LogViewerItem : public KListViewItem
{
public:
    /**
     * Constructor
     * @param parent The parent list view
     * @param after The item, the new item should be placed after
     * @param label1 The text for the first column
     */
    LogViewerItem( KListView* parent, LogViewerItem* after, TQString label1 );

    /**
     * Constructor
     * @param parent The parent list view item
     * @param after The item, the new item should be placed after
     * @param label1 The text for the first column
     */
    LogViewerItem( LogViewerItem* parent, LogViewerItem* after, TQString label1 );

    /**
     * Destructor
     */
    virtual ~LogViewerItem();

    virtual void paintCell( TQPainter* p, const TQColorGroup& cg, int column, int width, int alignment );

    LogViewerItem* nextSibling() const { return static_cast<LogViewerItem*>( KListViewItem::nextSibling() ); }
    LogViewerItem* firstChild() const { return static_cast<LogViewerItem*>( KListViewItem::firstChild() ); }

    bool converting;
};


/**
 * @short The log viewer list
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class LogViewerList : public KListView
{
    Q_OBJECT
  TQ_OBJECT
public:
    /**
     * Constructor
     * @param parent The parent widget
     * @param name The name of the file list
     */
    LogViewerList( TQWidget * parent = 0, const char* name = 0 );

    /**
     * Destructor
     */
    virtual ~LogViewerList();

    LogViewerItem* firstChild() const { return static_cast<LogViewerItem*>( KListView::firstChild() ); }
};


/**
 * @short Shows the logs that are collected by the logger
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class LogViewer : public KDialog
{
    Q_OBJECT
  TQ_OBJECT
public:
    /**
     * Default Constructor
     */
    LogViewer( Logger* _logger, TQWidget* parent=0, const char* name = 0, bool modal = true, WFlags f = 0 );

    /**
     * Default Destructor
     */
    virtual ~LogViewer();

private:
    Logger* logger;
    LogViewerList* lLogs;
    KPushButton* pOk;
    KPushButton* pReload;

private slots:
    void refillLogs();
    void updateProcess( int id );

public slots:
    /** get notification when a job has been removed */
    void processRemoved( int id );

};

#endif // LOGVIEWER_H
