
#include "logger.h"

#include <klocale.h>
#include <kstandarddirs.h>

#include <cstdlib>
#include <ctime>


LoggerItem::LoggerItem()
{}

LoggerItem::~LoggerItem()
{}


Logger::Logger()
{
    TQValueList<LoggerItem*>::Iterator item = processes.append( new LoggerItem() );
    (*item)->filename = "soundKonverter";
    (*item)->id = 1000;
    (*item)->completed = true;
    (*item)->state = 1;
    (*item)->file.setName( locateLocal("data",TQString("soundkonverter/log/%1.log").arg((*item)->id)) );
    // TODO error handling
    (*item)->file.open( IO_WriteOnly );
    (*item)->textStream.setDevice( TQT_TQIODEVICE(&((*item)->file)) );
    srand( (unsigned)time(NULL) );
}

Logger::~Logger()
{}

void Logger::cleanUp()
{
    for( TQValueList<LoggerItem*>::Iterator it = processes.begin(); it != processes.end(); ++it ) {
        if( (*it)->id != 1000 ) {
            emit removedProcess( (*it)->id );
            (*it)->file.close();
            (*it)->file.remove();
            delete *it;
        }
    }
    processes.clear();
}

int Logger::registerProcess( const TQString& filename )
{
    // NOTE ok, it works now, but why prepend() and not append()?
    TQValueList<LoggerItem*>::Iterator item = processes.append( new LoggerItem() );
    (*item)->filename = filename;
    (*item)->id = getNewID();
    (*item)->completed = false;
    (*item)->file.setName( locateLocal("data",TQString("soundkonverter/log/%1.log").arg((*item)->id)) );
    // TODO error handling
    (*item)->file.open( IO_WriteOnly );
    (*item)->textStream.setDevice( TQT_TQIODEVICE(&((*item)->file)) );

    emit updateProcess( (*item)->id );

    return (*item)->id;
}

void Logger::log( int id, const TQString& data )
{
    for( TQValueList<LoggerItem*>::Iterator it = processes.begin(); it != processes.end(); ++it ) {
        if( (*it)->id == id ) {
            (*it)->data.append( data );
            if( (*it)->data.count() > 100000 ) (*it)->data.erase( (*it)->data.at(0) );
            (*it)->textStream << data;
            (*it)->textStream << "\n";
            (*it)->file.flush();
            if( id == 1000 ) emit updateProcess( 1000 );
            return;
        }
    }
}

int Logger::getNewID()
{
    bool ok;
    int id;

    do {
        id = rand();
        ok = true;

        for( TQValueList<LoggerItem*>::Iterator it = processes.begin(); it != processes.end(); ++it ) {
            if( (*it)->id == id ) ok = false;
        }

    } while( !ok );

    return id;
}

LoggerItem* Logger::getLog( int id )
{
    for( TQValueList<LoggerItem*>::Iterator it = processes.begin(); it != processes.end(); ++it ) {
        if( (*it)->id == id ) return *it;
    }

    return 0;
}

TQValueList<LoggerItem*> Logger::getLogs()
{
/*    TQValueList<LoggerItem*> items;

    for( TQValueList<LoggerItem*>::Iterator it = processes.begin(); it != processes.end(); ++it ) {
        if( (*it)->completed ) items.append( *it );
    }

    return items;*/
    return processes;
}

void Logger::processCompleted( int id, int state )
{
    LoggerItem* item = 0;
    TQTime time = TQTime::currentTime();
    bool remove = false;

    for( TQValueList<LoggerItem*>::Iterator it = processes.begin(); it != processes.end(); ++it ) {
        // TODO test
        if( time >= (*it)->time && (*it)->completed && (*it)->state == 0 ) {
            time = (*it)->time;
            item = *it;
            remove = true;
        }
        else if( (*it)->id == id ) {
            (*it)->state = state;
            (*it)->completed = true;
            (*it)->time = (*it)->time.currentTime();
            (*it)->textStream << i18n("Finished logging");
            (*it)->file.close();
             emit updateProcess( id );
        }
    }

    if( remove && processes.count() > 11 ) {
        emit removedProcess( item->id );
        item->file.remove();
        processes.remove( item );
        delete item;
    }
}

