
#include "configgeneralpage.h"

#include "config.h"

#include <klocale.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kfiledialog.h>

#include <tqlayout.h>
#include <tqlabel.h>
#include <tqcheckbox.h>
#include <tqtooltip.h>
#include <tqdir.h>
#include <tqregexp.h>

// ### soundkonverter 0.4: add an option to use vfat save names when the output device is vfat

ConfigGeneralPage::ConfigGeneralPage( Config* _config, TQWidget *parent, const char *name )
    : ConfigPageBase( parent, name )
{
    config = _config;

    // create an icon loader object for loading icons
    KIconLoader* iconLoader = new KIconLoader();

    TQVBoxLayout* box = new TQVBoxLayout( parent, 0, 6 );

    TQHBoxLayout* startTabBox = new TQHBoxLayout( box, 6 );
    TQLabel* lStartTab = new TQLabel( i18n("Start in Mode")+":", parent, "lStartTab" );
    startTabBox->addWidget( lStartTab );
    cStartTab = new KComboBox( parent, "cStartTab" );
    cStartTab->insertItem( i18n("Last used") );
    cStartTab->insertItem( i18n("Simple") );
    cStartTab->insertItem( i18n("Detailed") );
    cStartTab->setCurrentItem( config->data.general.startTab );
    startTabBox->addWidget( cStartTab );
    connect( cStartTab, TQT_SIGNAL(activated(int)),
               this, TQT_SLOT(cfgChanged())
             );

    box->addSpacing( 5 );

    TQHBoxLayout* defaultProfileBox = new TQHBoxLayout( box, 6 );
    TQLabel* lDefaultProfile = new TQLabel( i18n("Default profile")+":", parent, "lDefaultProfile" );
    defaultProfileBox->addWidget( lDefaultProfile );
    cDefaultProfile = new KComboBox( parent, "cDefaultProfile" );
    sDefaultProfile += i18n("Very low");
    sDefaultProfile += i18n("Low");
    sDefaultProfile += i18n("Medium");
    sDefaultProfile += i18n("High");
    sDefaultProfile += i18n("Very high");
    sDefaultProfile += i18n("Lossless");
    sDefaultProfile += i18n("Hybrid");
    sDefaultProfile += config->getAllProfiles();
    sDefaultProfile.remove( i18n("Last used") );
    sDefaultProfile.remove( "Last used" );
    sDefaultProfile.prepend( i18n("Last used") );
    cDefaultProfile->insertStringList( sDefaultProfile );
    cDefaultProfile->setCurrentItem( profileIndex(config->data.general.defaultProfile) );
    defaultProfileBox->addWidget( cDefaultProfile );
    connect( cDefaultProfile, TQT_SIGNAL(activated(int)),
               this, TQT_SLOT(profileChanged())
             );
    connect( cDefaultProfile, TQT_SIGNAL(activated(int)),
               this, TQT_SLOT(cfgChanged())
             );
    TQLabel* lDefaultFormat = new TQLabel( i18n("Default format")+":", parent, "lDefaultFormat" );
    defaultProfileBox->addWidget( lDefaultFormat );
    cDefaultFormat = new KComboBox( parent, "cDefaultFormat" );
    defaultProfileBox->addWidget( cDefaultFormat );
    connect( cDefaultFormat, TQT_SIGNAL(activated(int)),
               this, TQT_SLOT(cfgChanged())
             );
    profileChanged();

    box->addSpacing( 5 );

/*    TQHBoxLayout* defaultDirBox = new TQHBoxLayout( box, 6 );
    TQLabel* lDefaultDir = new TQLabel( i18n("Default output directory")+":", parent, "lDefaultDir" );
    defaultDirBox->addWidget( lDefaultDir );
    lDir = new KLineEdit( parent, "lDir" );
    lDir->setText( config->data.general.defaultOutputDirectory );
    TQToolTip::add( lDir, i18n("<p>The following strings are space holders, that will be replaced by the information in the meta data:</p><p>%a - Artist<br>%b - Album<br>%c - Comment<br>%d - Disc number<br>%g - Genre<br>%n - Track number<br>%p - Composer<br>%t - Title<br>%y - Year<br>%f - Original file name<p>") );
    defaultDirBox->addWidget( lDir );
    connect( lDir, TQT_SIGNAL(textChanged(const TQString&)),
               this, TQT_SLOT(cfgChanged())
             );*/
    /*pDirInfo = new KPushButton( iconLoader->loadIcon("messagebox_info",KIcon::Small), "", parent, "pDirInfo" );
    TQToolTip::add( pDirInfo, i18n("Information about the wildcards.") );
    defaultDirBox->addWidget( pDirInfo );
    connect( pDirInfo, TQT_SIGNAL(clicked()),
               this, TQT_SLOT(dirInfo())
             );*/
//     pDirSelect = new KPushButton( iconLoader->loadIcon("folder",KIcon::Small), "", parent, "pDirSelect" );
//     TQToolTip::add( pDirSelect, i18n("Choose an output directory") );
//     defaultDirBox->addWidget( pDirSelect );
//     connect( pDirSelect, TQT_SIGNAL(clicked()),
//                this, TQT_SLOT(selectDir())
//              );

    TQHBoxLayout* priorityBox = new TQHBoxLayout( box, 6 );
    TQLabel* lPriority = new TQLabel( i18n("Process priority of the backends")+":", parent, "lPriority" );
    priorityBox->addWidget( lPriority );
    cPriority = new KComboBox( parent, "cPriority" );
    sPriority += i18n("Normal");
    sPriority += i18n("Low");
    cPriority->insertStringList( sPriority );
    cPriority->setCurrentItem( config->data.general.priority / 10 ); // NOTE that just works for 'normal' and 'low'
    priorityBox->addWidget( cPriority );
    connect( cPriority, TQT_SIGNAL(activated(int)),
               this, TQT_SLOT(cfgChanged())
             );

    box->addSpacing( 5 );

    TQHBoxLayout* useVFATNamesBox = new TQHBoxLayout( box, 6 );
    cUseVFATNames = new TQCheckBox( i18n("Use FAT compatible output file names"), parent, "cUseVFATNames" );
    TQToolTip::add( cUseVFATNames, i18n("Replaces some special characters like \'?\' by \'_\'.") );
    cUseVFATNames->setChecked( config->data.general.useVFATNames );
    useVFATNamesBox->addWidget( cUseVFATNames );
    connect( cUseVFATNames, TQT_SIGNAL(toggled(bool)),
               this, TQT_SLOT(cfgChanged())
             );

    box->addSpacing( 5 );

    TQHBoxLayout* conflictHandlingBox = new TQHBoxLayout( box, 6 );
    TQLabel* lConflictHandling = new TQLabel( i18n("Conflict handling")+":", parent, "lConflictHandling" );
    conflictHandlingBox->addWidget( lConflictHandling );
    cConflictHandling = new KComboBox( parent, "cConflictHandling" );
    TQToolTip::add( cConflictHandling, i18n("Do that if the output file already exists") );
    sConflictHandling += i18n("Generate new file name");
    sConflictHandling += i18n("Skip file");
    cConflictHandling->insertStringList( sConflictHandling );
    cConflictHandling->setCurrentItem( config->data.general.conflictHandling );
    conflictHandlingBox->addWidget( cConflictHandling );
    connect( cConflictHandling, TQT_SIGNAL(activated(int)),
             this, TQT_SLOT(cfgChanged())
           );

    box->addSpacing( 5 );

    TQHBoxLayout* numFilesBox = new TQHBoxLayout( box, 6 );
    TQLabel* lNumFiles = new TQLabel( i18n("Number of files to convert at once")+":", parent, "lNumFiles" );
    numFilesBox->addWidget( lNumFiles );
    iNumFiles = new KIntSpinBox( 1, 100, 1, config->data.general.numFiles, 10, parent, "iNumFiles" );
    numFilesBox->addWidget( iNumFiles );
    connect( iNumFiles, TQT_SIGNAL(valueChanged(int)),
               this, TQT_SLOT(cfgChanged())
             );

    box->addSpacing( 5 );

    TQHBoxLayout* updateDelayBox = new TQHBoxLayout( box, 6 );
    TQLabel* lUpdateDelay = new TQLabel( i18n("Status update delay (time in msec.)")+":", parent, "lUpdateDelay" );
    updateDelayBox->addWidget( lUpdateDelay );
    iUpdateDelay = new KIntSpinBox( 100, 5000, 100, config->data.general.updateDelay, 10, parent, "iUpdateDelay" );
    TQToolTip::add( iUpdateDelay, i18n("Update the progress bar in this interval (time in milliseconds)") );
    updateDelayBox->addWidget( iUpdateDelay );
    connect( iUpdateDelay, TQT_SIGNAL(valueChanged(int)),
               this, TQT_SLOT(cfgChanged())
             );

    box->addSpacing( 5 );

    TQHBoxLayout* askForNewOptionsBox = new TQHBoxLayout( box, 6 );
    cAskForNewOptions = new TQCheckBox( i18n("Ask for new options, when adding files from external program"), parent, "cAskForNewOptions" );
    TQToolTip::add( cAskForNewOptions, i18n("If you open a file with soundKonverter and soundKonverter is already running,\nyou can either be asked to define new converting options\nor the current settings from the soundKonverter main window are used.") );
    cAskForNewOptions->setChecked( config->data.general.askForNewOptions );
    askForNewOptionsBox->addWidget( cAskForNewOptions );
    connect( cAskForNewOptions, TQT_SIGNAL(toggled(bool)),
               this, TQT_SLOT(cfgChanged())
             );

    box->addSpacing( 5 );

    TQHBoxLayout* executeUserScriptBox = new TQHBoxLayout( box, 6 );
    cExecuteUserScript = new TQCheckBox( i18n("Execute user script (for advanced users)"), parent, "cAskForNewOptions" );
    TQToolTip::add( cExecuteUserScript, i18n("Executes a script after every finished conversion. Have a look at $KDEDIR/soundkonverter/userscript.sh") );
    cExecuteUserScript->setChecked( config->data.general.executeUserScript );
    executeUserScriptBox->addWidget( cExecuteUserScript );
    connect( cExecuteUserScript, TQT_SIGNAL(toggled(bool)),
             this, TQT_SLOT(cfgChanged())
           );

    box->addStretch();

    // delete the icon loader object
    delete iconLoader;
}

ConfigGeneralPage::~ConfigGeneralPage()
{}

void ConfigGeneralPage::resetDefaults()
{
    cStartTab->setCurrentItem( 0 );
    cDefaultProfile->setCurrentItem( 0 );
    cDefaultFormat->setCurrentItem( 0 );
//     lDir->setText( TQDir::homeDirPath() + "/soundKonverter/%b/%d - %n - %a - %t" );
    cPriority->setCurrentItem( 1 );
    cUseVFATNames->setChecked( true );
    cConflictHandling->setCurrentItem( 0 );
    iNumFiles->setValue( 3 );
    iUpdateDelay->setValue( 500 );
    cAskForNewOptions->setChecked( true );
    cExecuteUserScript->setChecked( false );

    cfgChanged();
}

void ConfigGeneralPage::saveSettings()
{
    config->data.general.startTab = cStartTab->currentItem();
    config->data.general.defaultProfile = cDefaultProfile->currentText();
    config->data.general.defaultFormat = cDefaultFormat->currentText();
//     config->data.general.defaultOutputDirectory = lDir->text();
    config->data.general.priority = cPriority->currentItem() * 10; // NOTE that just works for 'normal' and 'low'
    config->data.general.useVFATNames = cUseVFATNames->isChecked();
    config->data.general.conflictHandling = cConflictHandling->currentItem();
    config->data.general.numFiles = iNumFiles->value();
    config->data.general.updateDelay = iUpdateDelay->value();
    config->data.general.askForNewOptions = cAskForNewOptions->isChecked();
    config->data.general.executeUserScript = cExecuteUserScript->isChecked();
}

int ConfigGeneralPage::profileIndex( const TQString &string )
{
    return sDefaultProfile.findIndex( string );
}

int ConfigGeneralPage::formatIndex( const TQString &string )
{
    return sDefaultFormat.findIndex( string );
}

// void ConfigGeneralPage::selectDir()
// {
//     TQString startDir = lDir->text();
//     int i = startDir.find( TQRegExp("%[aAbBcCdDgGnNpPtTyY]{1,1}") );
//     if( i != -1 ) {
//         i = startDir.findRev( "/", i );
//         startDir = startDir.left( i );
//     }
// 
//     TQString directory = KFileDialog::getExistingDirectory( startDir, 0, i18n("Choose an output directory") );
//     if( !directory.isEmpty() ) {
//         TQString dir = lDir->text();
//         i = dir.find( TQRegExp("%[aAbBcCdDgGnNpPtTyY]{1,1}") );
//         if( i != -1 ) {
//             i = dir.findRev( "/", i );
//             lDir->setText( directory + dir.mid(i) );
//         }
//         else {
//             lDir->setText( directory );
//         }
//     }
// }

void ConfigGeneralPage::profileChanged()
{
    TQString last;

    if( cDefaultProfile->currentText() == i18n("Last used") ) {
        last = cDefaultFormat->currentText();
        if( last.isEmpty() ) last = config->data.general.defaultFormat;
        cDefaultFormat->clear();
        sDefaultFormat = i18n("Last used");
        cDefaultFormat->insertStringList( sDefaultFormat );
        cDefaultFormat->setCurrentItem( formatIndex(last) );
        return;
    }

    ConversionOptions options = config->getProfile( cDefaultProfile->currentText() );
    if( !options.encodingOptions.sFormat.isEmpty() ) {
        last = cDefaultFormat->currentText();
        cDefaultFormat->clear();
        sDefaultFormat = options.encodingOptions.sFormat;
        cDefaultFormat->insertStringList( sDefaultFormat );
        cDefaultFormat->setCurrentItem( formatIndex(last) );
        return;
    }

    if( cDefaultProfile->currentText() == i18n("Very low") ||
      cDefaultProfile->currentText() == i18n("Low") ||
      cDefaultProfile->currentText() == i18n("Medium") ||
      cDefaultProfile->currentText() == i18n("High") ||
      cDefaultProfile->currentText() == i18n("Very high") ) {
        last = cDefaultFormat->currentText();
        if( last.isEmpty() ) last = config->data.general.defaultFormat;
        cDefaultFormat->clear();
        sDefaultFormat = i18n("Last used");
        sDefaultFormat += config->allLossyEncodableFormats();
        cDefaultFormat->insertStringList( sDefaultFormat );
        cDefaultFormat->setCurrentItem( formatIndex(last) );
    }
    else if( cDefaultProfile->currentText() == i18n("Lossless") ) {
        last = cDefaultFormat->currentText();
        if( last.isEmpty() ) last = config->data.general.defaultFormat;
        cDefaultFormat->clear();
        sDefaultFormat = i18n("Last used");
        sDefaultFormat += config->allLosslessEncodableFormats();
        sDefaultFormat += "wav";
        cDefaultFormat->insertStringList( sDefaultFormat );
        cDefaultFormat->setCurrentItem( formatIndex(last) );
    }
    else if( cDefaultProfile->currentText() == i18n("Hybrid") ) {
        last = cDefaultFormat->currentText();
        if( last.isEmpty() ) last = config->data.general.defaultFormat;
        cDefaultFormat->clear();
        sDefaultFormat = i18n("Last used");
        sDefaultFormat += config->allHybridEncodableFormats();
        cDefaultFormat->insertStringList( sDefaultFormat );
        cDefaultFormat->setCurrentItem( formatIndex(last) );
    }
}


