

#ifndef CONFIGENVIRONMENTPAGE_H
#define CONFIGENVIRONMENTPAGE_H

#include <configpagebase.h>

class Config;
class KPushButton;
class KListBox;

/**
* @short The page for configuring the environment
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConfigEnvironmentPage : public ConfigPageBase
{
    Q_OBJECT
  TQ_OBJECT
public:
    /**
     * Default Constructor
     */
    ConfigEnvironmentPage( Config*, TQMap<TQString, TQString>*, TQWidget *parent=0, const char *name=0 );

    /**
     * Default Destructor
     */
    virtual ~ConfigEnvironmentPage();

private:
    KListBox* lDirectories;
    KPushButton* pDirUp;
    KPushButton* pDirDown;
    KPushButton* pAddDirectory;
    KPushButton* pRemoveDirectory;
    KListBox* lFoundPrograms;
    KListBox* lNotFoundPrograms;

    Config* config;

    TQMap<TQString, TQString>* binaries;

public slots:
    void resetDefaults();
    void saveSettings();

private slots:
    void directoriesSelectionChanged( int );
    void dirUp();
    void dirDown();
    void addDirectory();
    void removeDirectory();
    void refill();

signals:
    void rebuildBackendsPage();

};

#endif // CONFIGENVIRONMENTPAGE_H

