

#ifndef CONFIGBACKENDSPAGE_H
#define CONFIGBACKENDSPAGE_H

#include <configpagebase.h>

#include <tqstringlist.h>

class Config;
class KComboBox;
class KScrollView;
class TQGroupBox;
class TQGridLayout;
class TQLabel;
class TQSlider;
class TQCheckBox;
class TQVBox;

/**
* @short The page for configuring the environment
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConfigBackendsPage : public ConfigPageBase
{
    Q_OBJECT
  TQ_OBJECT
public:
    /**
     * Default Constructor
     */
    ConfigBackendsPage( Config*, TQMap<TQString, TQString>*, TQWidget *parent=0, const char *name=0 );

    /**
     * Default Destructor
     */
    virtual ~ConfigBackendsPage();

private:
    struct FormatOptions
    {
        // TODO remove the string lists
        TQString format;
        TQGroupBox* group;
        TQGridLayout* grid;
        TQLabel* lEncoder;
        KComboBox* cEncoder;
        TQLabel* lStrength;
        TQSlider* sStrength;
        TQLabel* lStrengthDisplay;
        TQLabel* lDecoder;
        KComboBox* cDecoder;
        TQLabel* lReplayGain;
        KComboBox* cReplayGain;
        TQCheckBox* cInternalReplayGain;
    };

    TQValueList<FormatOptions> formatOptions;

    TQGridLayout* grid;
    KScrollView* scrollView;
    TQVBox* box;

    KComboBox* cRipper;

    Config* config;

    TQMap<TQString, TQString>* binaries;

public slots:
    void resetDefaults();
    void saveSettings();
    void rebuild();
    void refill();
    void encoderChanged();
    void strengthChanged();

};

#endif // CONFIGBACKENDSPAGE_H

