

#ifndef CDMANAGER_H
#define CDMANAGER_H

#include "tagengine.h"

#include <tqobject.h>

class ConversionOptions;
class Paranoia;

/**
 * @short All data needed for a cd device
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class CDDevice
{
public:
    /**
     * Constructor
     */
    CDDevice( const TQString& _device="" );

    /**
     * Destructor
     */
    virtual ~CDDevice();

    TQString device;
    Paranoia* para;
    TQValueList<TagData*> tags;
    TagData* discTags;
    int trackCount;
    int timeCount;
};

/**
 * @short The CD manager
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class CDManager : public TQObject
{
    Q_OBJECT
  TQ_OBJECT
public:
    /**
     * Constructor
     */
    CDManager();

    /**
     * Destructor
     */
    virtual ~CDManager();

    /**
     * Create a new CDDevice entry in cdDevices. Use @param device or auto search for an audio cd
     * Return the used device (usefull, if auto searching was used)
     */
    TQString newCDDevice( const TQString& device="" );

    /**
     * Return a list of all tracks on the cd in drive @param device
     */
    TQValueList<TagData*> getTrackList( const TQString& device );

    /**
     * Return the tags of the track @param track on the cd in drive @param device
     */
    TagData* getTags( const TQString& device, int track );

    /**
     * Set the tags of the cd in drive @param device
     */
    void setDiscTags( const TQString& device, TagData* tags );

    /**
     * Return the sum of all tracks of the cd in drive @param device
     */
    int getTrackCount( const TQString& device );

    /**
     * Return the complete length of the cd in drive @param device
     */
    int getTimeCount( const TQString& device );

private:
    /** a list of all devices */
    TQValueList<CDDevice*> cdDevices;

};

#endif // CDMANAGER_H
