/***************************************************************************
    smb4kshareslistview_part  -This Part includes the shares list view
    of Smb4K.
                             -------------------
    begin                : Sa Jun 30 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSHARESLISTVIEW_PART_H
#define SMB4KSHARESLISTVIEW_PART_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// KDE includes
#include <kparts/part.h>
#include <kparts/factory.h>

// applications specific includes
#include "smb4kshareslistview.h"

/**
 * This is one of the parts of Smb4K. It contains the shares list
 * view.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KSharesListViewPart : public KParts::Part
{
  Q_OBJECT
  TQ_OBJECT

  public:
    /**
     * The constructor.
     *
     * @param parentWidget        The parent widget
     *
     * @param widgetName          The name the widget should have
     *
     * @param parent              The parent object
     *
     * @param name                The name this object should have
     */
    Smb4KSharesListViewPart( TQWidget *parentWidget = 0, const char *widgetName = 0,
                             TQObject *parent = 0, const char *name = 0 );

    /**
     * The destructor.
     */
    virtual ~Smb4KSharesListViewPart();

  protected:
    /**
     * Reimplemented from KParts::Part.
     */
    void customEvent( TQCustomEvent *e );

  protected slots:
    /**
     * Opens a context menu over the list view item @p item at position
     * @p pos if requested.
     *
     * @param item                The list view item or NULL if the user clicked
     *                            somewhere else.
     *
     * @param pos                 The position where the user clicked.
     *
     * @param col                 The column where the context menu should be show.
     */
    void slotContextMenuRequested( TQListViewItem *item, const TQPoint & pos, int col );

    /**
     * This slot is called when the selection in the list view changed. It
     * enables or disables the actions according to known options/states.
     * Please note that it won't be invoked when the user clicked on the
     * viewport. Use slotMouseButtonPressed() to also catch that event.
     *
     * @param item                The list view item that was selected
     */
    void slotSelectionChanged( TQListViewItem *item );

    /**
     * This slot is called when the user presses any mouse button somewhere
     * in the list view. It enables or disables the actions according to known
     * options/states.
     *
     * @param item                The icon view item that was clicked or NULL if the
     *                            user clicked onto the viewport.
     */
    void slotMouseButtonPressed( TQListViewItem *item );

    /**
     * This slot is called by the Smb4KMounter::updated() signal and updates
     * the list view according to the list that is returned by Smb4KMounter::getShares().
     */
    void slotMountedShares();

    /**
     * This slot is connected to the 'Unmount action'. You will be able to
     * unmount a certain share when activating this slot.
     */
    void slotUnmountShare();

    /**
     * This slot is connected to the 'Force Unmounting' action and is, thus,
     * only useful under Linux, because only there the possibility for a forced
     * (i.e. lazy) unmount exists.
     *
     * When activating this slot, the selected share will be unmounted, even if
     * it is not accessible or the server already went offline.
     */
    void slotForceUnmountShare();

    /**
     * This slot is connected to the 'Unmount All' action. All shares - either of
     * the user or that are present on the system (depending on the settings the
     * user chose) - will be unmounted. Please note that Smb4KMounter::unmountAllShares()
     * is invoked directly.
     */
    void slotUnmountAllShares();

    /**
     * This slot is connected to the 'Synchronize' action. The current item will be
     * synchronized with a local copy (or vice versa) if you activate it.
     */
    void slotSynchronize();

    /**
     * This slot is connected to the 'Konsole' action. The mount point of the current
     * share item will be opened in Konsole.
     */
    void slotKonsole();

    /**
     * This slot is connected to the 'Konqueror' action. The contents of the current
     * share item will be opened in the file manager.
     */
    void slotFilemanager();

    /**
     * This slot is called by the synchronizer whenever the state of the synchronization
     * process changed.
     *
     * @param state             The state the synchronizer is in.
     */
    void slotSynchronizationState( int state );

  private:
    /**
     * Set up the actions
     */
    void setupActions();

    /**
     * Load settings for the widget or the actions.
     */
    void loadSettings();

    /**
     * The icon view.
     */
    Smb4KSharesListView *m_widget;

    /**
     * The action menu.
     */
    KActionMenu *m_menu;
};


class KInstance;
class KAboutData;

class Smb4KSharesListViewPartFactory : public KParts::Factory
{
  Q_OBJECT
  TQ_OBJECT

  public:
    /**
     * The constructor
     */
    Smb4KSharesListViewPartFactory();

    /**
     * The destructor
     */
    virtual ~Smb4KSharesListViewPartFactory();

    /**
     * Reimplemented from KParts::Factory
     */
    virtual KParts::Part *createPartObject( TQWidget *parentWidget, const char *widgetName,
                                            TQObject *parent, const char *name,
                                            const char *classname, const TQStringList &args );

    /**
     * The instance
     */
    static KInstance *instance();

  private:
    /**
     * The factory's instance.
     */
    static KInstance *m_instance;

    /**
     * The factory's KAboutData object
     */
    static KAboutData *m_about;
};


#endif
