/***************************************************************************
    smb4ksharesiconviewtooltip  -  Tool tip for the shares icon view.
                             -------------------
    begin                : Do Jan 4 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqtooltip.h>
#include <tqapplication.h>
#include <tqdesktopwidget.h>
#include <tqtimer.h>

// KDE includes
#include <klocale.h>
#include <kdebug.h>

// application specific includes
#include "smb4ksharesiconviewtooltip.h"
#include "smb4ksharesiconviewitem.h"


Smb4KSharesIconViewToolTip::Smb4KSharesIconViewToolTip( Smb4KSharesIconViewItem *item )
: TQLabel( 0, "SharesIconViewToolTip", WStyle_StaysOnTop | WStyle_Customize |
WStyle_NoBorder | WStyle_Tool | WX11BypassWM | WDestructiveClose ), m_item( item )
{
  setPalette( TQToolTip::palette() );
  setLineWidth( 1 );
  setMidLineWidth( 1 );
  setFrameShape( Box );
  setFrameShadow( Plain );
  setMouseTracking( true );

  m_layout = new TQGridLayout( this );
  m_layout->setMargin( 10 );
  m_layout->setSpacing( 3 );

  m_is_set_up = false;

  m_free = NULL;
  m_used = NULL;
  m_total = NULL;
  m_usage = NULL;
  m_pixmap = NULL;

  // We will set up the tip in the showTip() function.
}


Smb4KSharesIconViewToolTip::~Smb4KSharesIconViewToolTip()
{
  // Never touch the Smb4KSharesIconViewItem object here!
}


void Smb4KSharesIconViewToolTip::showTip( const TQPoint &pos )
{
  if ( !m_item || isShown() )
  {
    return;
  }

  setupTip();

  adjustSize();

  TQDesktopWidget *d = TQApplication::desktop();
  TQPoint p( pos );

  if ( p.x() + width() > d->width() )
  {
    p.setX( p.x() - width() - 5 );
  }
  else
  {
    p.setX( p.x() + 5 );
  }

  if ( p.y() + height() > d->height() )
  {
    p.setY( p.y() - height() - 5 );
  }
  else
  {
    p.setY( p.y() + 5 );
  }

  setGeometry( p.x(), p.y(), width(), height() );
  polish();
  show();
  TQTimer::singleShot( 10000, this, TQT_SLOT( slotHideToolTip() ) );
}


void Smb4KSharesIconViewToolTip::setupTip()
{
  if ( !m_item )
  {
    return;
  }

  m_layout->addWidget( new TQLabel( i18n( "Share:" ), this ), 0, 1, 0 );
  m_layout->addWidget( new TQLabel( m_item->shareObject()->name(), this ), 0, 2, 0 );
  m_layout->addWidget( new TQLabel( i18n( "Mount point:" ), this ), 1, 1, 0 );
  m_layout->addWidget( new TQLabel( m_item->shareObject()->path(), this ), 1, 2, 0 );

  if ( TQString::compare( m_item->shareObject()->filesystem(), "smbfs" ) == 0 )
  {
    m_layout->addWidget( new TQLabel( "Owner:", this ), 2, 1, 0 );
    m_layout->addWidget( new TQLabel( TQString( "%1 - %2" ).arg( m_item->shareObject()->user(), m_item->shareObject()->group() ), this ), 2, 2, 0 );
  }
  else
  {
    m_layout->addWidget( new TQLabel( "Login:", this ), 2, 1, 0 );
    m_layout->addWidget( new TQLabel( m_item->shareObject()->cifsLogin(), this ), 2, 2, 0 );
  }

  m_layout->addWidget( new TQLabel( i18n( "File system:" ), this ), 3, 1, 0 );
  m_layout->addWidget( new TQLabel( m_item->shareObject()->filesystem().upper(), this ), 3, 2, 0 );

  TQFrame *line = new TQFrame( this );
  line->setLineWidth( 1 );
  line->setMidLineWidth( 0 );
  line->setFixedWidth( 100 );
  line->setFrameShape( TQFrame::HLine );
  line->setFrameShadow( TQFrame::Plain );

  m_layout->addMultiCellWidget( line, 4, 4, 1, 2, TQt::AlignCenter );

  // Prepare the disk usage stuff.
  if ( !m_item->shareObject()->isBroken() )
  {
    TQString total, free, used, total_dim, free_dim, used_dim;

    if ( m_item->shareObject()->totalDiskSpace() - m_item->shareObject()->freeDiskSpace() > 1024 )
    {
      double tmp_used = (m_item->shareObject()->totalDiskSpace() - m_item->shareObject()->freeDiskSpace()) / 1024;
      used_dim = "MB";

      if ( tmp_used >= 1024 )
      {
        tmp_used = tmp_used / 1024;
        used_dim = "GB";
      }

      used = TQString( "%1" ).arg( tmp_used, 0, 'f', 1 );
    }
    else
    {
      used_dim = "kB";
      double tmp_used = m_item->shareObject()->totalDiskSpace() - m_item->shareObject()->freeDiskSpace();
      used = TQString( "%1" ).arg( tmp_used, 0, 'f', 1 );
    }

    if ( m_item->shareObject()->freeDiskSpace() >= 1024 )
    {
      double tmp_free = m_item->shareObject()->freeDiskSpace() / 1024;
      free_dim = "MB";

      if ( tmp_free >= 1024 )
      {
        tmp_free = tmp_free / 1024;
        free_dim = "GB";
      }

      free = TQString( "%1" ).arg( tmp_free, 0, 'f', 1 );
    }
    else
    {
      free_dim = "kB";
      free = TQString( "%1" ).arg( m_item->shareObject()->freeDiskSpace(), 0, 'f', 1 );
    }

    if ( m_item->shareObject()->totalDiskSpace() >= 1024 )
    {
      double tmp_total = m_item->shareObject()->totalDiskSpace() / 1024;
      total_dim = "MB";

      if ( tmp_total >= 1024 )
      {
        tmp_total = tmp_total / 1024;
        total_dim = "GB";
      }

      total = TQString( "%1" ).arg( tmp_total, 0, 'f', 1 );
    }
    else
    {
      total_dim = "kB";
      total = TQString( "%1" ).arg( m_item->shareObject()->totalDiskSpace(), 0, 'f', 1 );
    }

    m_layout->addWidget( new TQLabel( i18n( "Free:" ), this, "FreeLabel" ), 5, 1, 0 );
    m_free = new TQLabel( TQString( "%1 %2" ).arg( free, free_dim ), this );
    m_layout->addWidget( m_free, 5, 2, 0 );

    m_layout->addWidget( new TQLabel( i18n( "Used:" ), this, "UsedLabel" ), 6, 1, 0 );
    m_used = new TQLabel( TQString( "%1 %2" ).arg( used, used_dim ), this );
    m_layout->addWidget( m_used, 6, 2, 0 );

    m_layout->addWidget( new TQLabel( i18n( "Total:" ), this, "TotalLabel" ), 7, 1, 0 );
    m_total = new TQLabel( TQString( "%1 %2" ).arg( total, total_dim ), this );
    m_layout->addWidget( m_total, 7, 2, 0 );

    m_layout->addWidget( new TQLabel( i18n( "Usage:" ), this, "UsageLabel" ), 8, 1, 0 );
    m_usage = new TQLabel( TQString( "%1 %" ).arg( m_item->shareObject()->percentage(), 0, 'f', 1 ), this );
    m_layout->addWidget( m_usage, 8, 2, 0 );
  }
  else
  {
    TQLabel *error = new TQLabel( i18n( "This share is inaccessible." ), this  );

    TQFont font;
    font.setItalic( true );

    error->setFont( font );

    m_layout->addMultiCellWidget( error, 5, 5, 1, 2, TQt::AlignCenter );
  }

  m_pixmap = new TQLabel( this );
  m_pixmap->setPixmap( m_item->desktopPixmap() );

  m_layout->addMultiCellWidget( m_pixmap, 0, m_layout->numRows(), 0, 0, TQt::AlignCenter );

  m_is_set_up = true;
}


void Smb4KSharesIconViewToolTip::update()
{
  if ( !m_is_set_up )
  {
    return;
  }

  // Only change the variable entries:
  if ( !m_item->shareObject()->isBroken() )
  {
    TQString total, free, used, total_dim, free_dim, used_dim;

    if ( m_item->shareObject()->totalDiskSpace() - m_item->shareObject()->freeDiskSpace() > 1024 )
    {
      double tmp_used = (m_item->shareObject()->totalDiskSpace() - m_item->shareObject()->freeDiskSpace()) / 1024;
      used_dim = "MB";

      if ( tmp_used >= 1024 )
      {
        tmp_used = tmp_used / 1024;
        used_dim = "GB";
      }

      used = TQString( "%1" ).arg( tmp_used, 0, 'f', 1 );
    }
    else
    {
      used_dim = "kB";
      double tmp_used = m_item->shareObject()->totalDiskSpace() - m_item->shareObject()->freeDiskSpace();
      used = TQString( "%1" ).arg( tmp_used, 0, 'f', 1 );
    }

    if ( m_item->shareObject()->freeDiskSpace() >= 1024 )
    {
      double tmp_free = m_item->shareObject()->freeDiskSpace() / 1024;
      free_dim = "MB";

      if ( tmp_free >= 1024 )
      {
        tmp_free = tmp_free / 1024;
        free_dim = "GB";
      }

      free = TQString( "%1" ).arg( tmp_free, 0, 'f', 1 );
    }
    else
    {
      free_dim = "kB";
      free = TQString( "%1" ).arg( m_item->shareObject()->freeDiskSpace(), 0, 'f', 1 );
    }

    if ( m_item->shareObject()->totalDiskSpace() >= 1024 )
    {
      double tmp_total = m_item->shareObject()->totalDiskSpace() / 1024;
      total_dim = "MB";

      if ( tmp_total >= 1024 )
      {
        tmp_total = tmp_total / 1024;
        total_dim = "GB";
      }

      total = TQString( "%1" ).arg( tmp_total, 0, 'f', 1 );
    }
    else
    {
      total_dim = "kB";
      total = TQString( "%1" ).arg( m_item->shareObject()->totalDiskSpace(), 0, 'f', 1 );
    }

    m_free->setText( TQString( "%1 %2" ).arg( free, free_dim ) );
    m_used->setText( TQString( "%1 %2" ).arg( used, used_dim ) );
    m_total->setText( TQString( "%1 %2" ).arg( total, total_dim ) );
    m_usage->setText( TQString( "%1 %" ).arg( m_item->shareObject()->percentage(), 0, 'f', 1 ) );
  }
  else
  {
    TQLabel *free_label = static_cast<TQLabel *>( TQT_TQWIDGET(child( "FreeLabel", TQLABEL_OBJECT_NAME_STRING )) );

    if ( free_label )
    {
      m_layout->remove( free_label );
      delete free_label;
    }

    if ( m_free )
    {
      m_layout->remove( m_free );
      delete m_free;
      m_free = NULL;
    }

    TQLabel *used_label = static_cast<TQLabel *>( TQT_TQWIDGET(child( "UsedLabel", TQLABEL_OBJECT_NAME_STRING )) );

    if ( used_label )
    {
      m_layout->remove( used_label );
      delete used_label;
    }

    if ( m_used )
    {
      m_layout->remove( m_used );
      delete m_used;
      m_used = NULL;
    }

    TQLabel *total_label = static_cast<TQLabel *>( TQT_TQWIDGET(child( "TotalLabel", TQLABEL_OBJECT_NAME_STRING )) );

    if ( total_label )
    {
      m_layout->remove( total_label );
      delete total_label;
    }

    if ( m_total )
    {
      m_layout->remove( m_total );
      delete m_total;
      m_total = NULL;
    }

    TQLabel *usage_label = static_cast<TQLabel *>( TQT_TQWIDGET(child( "UsageLabel", TQLABEL_OBJECT_NAME_STRING )) );

    if ( usage_label )
    {
      m_layout->remove( usage_label );
      delete usage_label;
    }

    if ( m_usage )
    {
      m_layout->remove( m_usage );
      delete m_usage;
      m_usage = NULL;
    }

    TQFont font;
    font.setItalic( true );

    TQLabel *error = new TQLabel( i18n( "This share is inaccessible." ), this  );
    error->setFont( font );
    error->show();

    m_layout->remove( m_pixmap );
    m_pixmap->setPixmap( m_item->desktopPixmap() );

    m_layout->addMultiCellWidget( error, 5, 5, 1, 2, TQt::AlignCenter );
    m_layout->addMultiCellWidget( m_pixmap, 0, 5, 0, 0, TQt::AlignCenter );
  }

  adjustSize();
}


void Smb4KSharesIconViewToolTip::mousePressEvent( TQMouseEvent *e )
{
  hide();
  TQLabel::mousePressEvent( e );
}


void Smb4KSharesIconViewToolTip::leaveEvent( TQEvent *e )
{
  hide();
  TQLabel::leaveEvent( e );
}


/////////////////////////////////////////////////////////////////////////////
// TQT_SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KSharesIconViewToolTip::slotHideToolTip()
{
  if ( isShown() )
  {
    hide();
  }
}

#include "smb4ksharesiconviewtooltip.moc"
