/***************************************************************************
    smb4ksharesiconview  -  This is the shares icon view of Smb4K.
                             -------------------
    begin                : Mo Dez 4 2006
    copyright            : (C) 2006 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// KDE includes
#include <kdebug.h>
#include <kurl.h>
#include <kio/job.h>
#include <kdeversion.h>

// application specific includes
#include "smb4ksharesiconview.h"
#include "smb4ksharesiconviewitem.h"
#include "smb4ksharesiconviewtooltip.h"
#include "../core/smb4kshare.h"
#include "../core/smb4ksettings.h"
#include "../core/smb4kcore.h"


Smb4KSharesIconView::Smb4KSharesIconView( TQWidget *parent, const char *name )
: KIconView( parent, name )
{
  setSelectionMode( KIconView::Single ); // If this is changed, revise dragObject() function.
  setResizeMode( KIconView::Adjust );
  setAutoArrange( true );
  setSorting( true, true );
  setItemsMovable( false );
  setAcceptDrops( true );
  setItemTextPos( KIconView::Bottom );
  setMaxItemWidth( 150 );
  setArrangement( KIconView::LeftToRight );
  setWordWrapIconText( true );

  m_tooltip = NULL;

  // Connections:
  connect( this, TQT_SIGNAL( pressed( TQIconViewItem * ) ),
           this, TQT_SLOT( slotPressed( TQIconViewItem * ) ) );
}


Smb4KSharesIconView::~Smb4KSharesIconView()
{
  // The tool tip's parent is 0 and not this icon view.
  if ( m_tooltip )
  {
    delete m_tooltip;
  }
}


void Smb4KSharesIconView::updateToolTip()
{
  if ( !m_tooltip )
  {
    return;
  }

  m_tooltip->update();
}


KURLDrag *Smb4KSharesIconView::dragObject()
{
  // Get the KURL of the item that is to be dragged:
  KURL url = KURL( static_cast<Smb4KSharesIconViewItem *>( currentItem() )->shareObject()->canonicalPath() );

  KURLDrag *drag = new KURLDrag( KURL::List( url ), this );
  drag->setPixmap( DesktopIcon( "folder" ) );
//   drag->dragCopy();

  return drag;
}


void Smb4KSharesIconView::startDrag()
{
  // Kill the tooltip, so it is not in the way:
  if ( m_tooltip )
  {
    delete m_tooltip;
    m_tooltip = NULL;
  }

  if ( !Smb4KSettings::enableDragSupport() )
  {
    return;
  }

  KIconView::startDrag();
}


void Smb4KSharesIconView::contentsDragEnterEvent( TQDragEnterEvent *e )
{
  e->accept( Smb4KSettings::enableDropSupport() );
}


void Smb4KSharesIconView::contentsDragMoveEvent( TQDragMoveEvent *e )
{
  TQIconViewItem *item = findItem( e->pos() );

  e->accept( Smb4KSettings::enableDropSupport() && item );
}


void Smb4KSharesIconView::contentsDropEvent( TQDropEvent *e )
{
  TQIconViewItem *item = findItem( e->pos() );
  KURL::List src;

  // Do we have to stop here?
  if ( !Smb4KSettings::enableDropSupport() ||
       !item ||
       !KURLDrag::decode( e, src ) )
  {
    e->ignore();

    return;
  }

  KURL dest;
  dest.setPath( static_cast<Smb4KSharesIconViewItem *>( item )->shareObject()->canonicalPath() );

  // Deny dropping if we dropped something on itself.
  // This was inspired by KonqOperations::doDrop() function.
  for ( KURL::List::Iterator it = src.begin(); it != src.end(); ++it )
  {
    if ( dest.equals( *it, true ) )
    {
      if ( e->source() == this || TQT_BASE_OBJECT(e->source()->parent()) == TQT_BASE_OBJECT(this) )
      {
        e->ignore();

        return;
      }
    }
  }

  // We only allow copying:
  KIO::CopyJob *job = KIO::copy( src, dest, true );
  job->setAutoErrorHandlingEnabled( true, NULL );
#if KDE_VERSION_MAJOR >= 3 && KDE_VERSION_MINOR >= 5
  job->setAutoWarningHandlingEnabled( true );
#endif
}


void Smb4KSharesIconView::contentsMouseMoveEvent( TQMouseEvent *e )
{
  m_pos = e->globalPos();

  Smb4KSharesIconViewItem *item = static_cast<Smb4KSharesIconViewItem *>( findItem( e->pos() ) );

  if ( item )
  {
    if ( m_tooltip )
    {
      // Check if tool tip is still valid:
      if ( m_tooltip->item() != item )
      {
        delete m_tooltip;

        if ( hasMouse() && Smb4KSettings::showShareToolTip() )
        {
          m_tooltip = new Smb4KSharesIconViewToolTip( item );

          TQTimer::singleShot( 2000, this, TQT_SLOT( slotShowToolTip() ) );
        }
        else
        {
          m_tooltip = NULL;
        }
      }
      else
      {
        // Do nothing
      }

    }
    else
    {
      // Create new tool tip:
      if ( hasMouse() && Smb4KSettings::showShareToolTip() )
      {
        m_tooltip = new Smb4KSharesIconViewToolTip( item );

        TQTimer::singleShot( 2000, this, TQT_SLOT( slotShowToolTip() ) );
      }
      else
      {
        // Do nothing
      }
    }
  }
  else
  {
    if ( m_tooltip )
    {
      delete m_tooltip;
      m_tooltip = NULL;
    }
  }

  KIconView::contentsMouseMoveEvent( e );
}


/////////////////////////////////////////////////////////////////////////////
// TQT_SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KSharesIconView::slotPressed( TQIconViewItem *item )
{
  if ( m_tooltip )
  {
    delete m_tooltip;
    m_tooltip = NULL;
  }

  if ( !item )
  {
    // Clear the selection if the user clicked onto the
    // viewport:
    clearSelection();
  }
  else
  {
    // Do nothing
  }
}


void Smb4KSharesIconView::slotShowToolTip()
{
  if ( m_tooltip && hasMouse() && Smb4KSettings::showShareToolTip() &&
       (m_tooltip->item() == static_cast<Smb4KSharesIconViewItem *>( findItem( viewport()->mapFromGlobal( m_pos ) ) )) )
  {
    m_tooltip->showTip( m_pos );
  }
  else
  {
    delete m_tooltip;
    m_tooltip = NULL;
  }
}


#include "smb4ksharesiconview.moc"
