/***************************************************************************
    smb4kglobal  -  This is the global namespace for Smb4K.
                             -------------------
    begin                : Sa Apr 2 2005
    copyright            : (C) 2005-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// KDE includes
#include <kconfig.h>
#include <kdebug.h>

// application specific includes
#include "smb4kglobal.h"
#include "smb4kglobal_p.h"
#include "smb4kdefs.h"


static Smb4KGlobalPrivate p;


TQTimer *Smb4KGlobal::timer()
{
  return p.timer();
}


const int Smb4KGlobal::timerInterval()
{
  return TIMER_INTERVAL;
}


const TQString Smb4KGlobal::specifyUser( const TQString &host, TQWidget *parent, const char *name )
{
  return p.homesHandler()->specifyUser( host, parent, name );
}


Smb4KPasswordHandler *Smb4KGlobal::passwordHandler()
{
  return p.passwordHandler();
}


Smb4KSambaOptionsHandler *Smb4KGlobal::optionsHandler()
{
  return p.optionsHandler();
}


const TQString &Smb4KGlobal::tempDir()
{
  return p.tempDir();
}


const TQStringList Smb4KGlobal::homesUsers( const TQString &host )
{
  return p.homesUsers( host );
}
