/***************************************************************************
    smb4krsyncoptions  -  The configuration page for the rsync options
                             -------------------
    begin                : So Nov 20 2005
    copyright            : (C) 2005-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KRSYNCOPTIONS_H
#define SMB4KRSYNCOPTIONS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// TQt includes
#include <tqtabwidget.h>


/**
 * This class belongs to the configuration dialog and takes
 * care of the options that can be defined for rsync.
 *
 * @author Alexander Reinholdt <dustpuppy@users.berlios.de>
 */

class Smb4KRsyncOptions : public TQTabWidget
{
  Q_OBJECT
  TQ_OBJECT

  public:
    /**
     * The constructor.
     *
     * @param parent        The parent widget
     *
     * @param name          The name of this widget
     */
    Smb4KRsyncOptions( TQWidget *parent = 0, const char *name = 0 );

    /**
     * The destructor
     */
    ~Smb4KRsyncOptions();

  protected slots:
    /**
     * This slot is invoked if the "Archive mode" checkbox has been
     * toggled.
     *
     * @param on            Is TRUE if the checkbox is checked and FALSE otherwise.
     */
    void slotArchiveToggled( bool on );

    /**
     * This slot is invoked if the --archive option has to be switched
     * off.
     *
     * @param on            Is FALSE if one of the connected checkboxes is unchecked
     *                      and TRUE otherwise.
     */
    void slotUncheckArchive( bool on );

    /**
     * This slot is called, when the backup checkbox has been toggled.
     * It enables/disables all other backup options according to the
     * state the backup button is in.
     *
     * @param on            Is TRUE if the m_backup check box has been
     *                      checked and FALSE otherwise.
     */
    void slotBackupToggled( bool on );

    /**
     * This slot is called if the '-F' shortcut has been toggled.
     * It unchecks the '-F -F' shortcut.
     *
     * @param on            Is TRUE is m_f_filter is checked and FALSE otherwise.
     */
    void slotFShortcutToggled( bool on );

    /**
     * This slot is called if the '-F -F' shortcut has been toggled.
     * It unchecks the '-F' shortcut.
     *
     * @param on            Is TRUE is m_ff_filter is checked and FALSE otherwise.
     */
    void slotFFShortcutToggled( bool on );
};

#endif
