/***************************************************************************
    smb4knetworkoptions  -  The configuration page for the network
    settings of Smb4K
                             -------------------
    begin                : Sa Nov 15 2003
    copyright            : (C) 2003-2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqbuttongroup.h>
#include <tqlayout.h>
#include <tqradiobutton.h>
#include <tqlabel.h>

// KDE includes
#include <klocale.h>
#include <klineedit.h>
#include <kcombobox.h>

// application specific includes
#include "smb4knetworkoptions.h"
#include "../core/smb4ksettings.h"

Smb4KNetworkOptions::Smb4KNetworkOptions( TQWidget *parent, const char *name ) : TQWidget( parent, name )
{
  TQGridLayout *grid = new TQGridLayout( this );
  grid->setSpacing( 10 );

  //
  // The browse list group box.
  //
  TQButtonGroup *browse_box =       new TQButtonGroup( 1, Qt::Horizontal, i18n( "Browse List" ),
                                   this, "kcfg_BrowseList" );

  browse_box->insert( new TQRadioButton( i18n( "Scan the network neighborhood for available workgroups and domains" ),
                      browse_box ), Smb4KSettings::EnumBrowseList::LookupDomains );
  browse_box->insert( new TQRadioButton( i18n( "Query the current workgroup master browser" ),
                      browse_box), Smb4KSettings::EnumBrowseList::QueryCurrentMaster );

  TQWidget *buttonWidget =          new TQWidget( browse_box );
  TQGridLayout *buttonLayout =      new TQGridLayout( buttonWidget );
  buttonLayout->setSpacing( 5 );

  TQRadioButton *use_host =         new TQRadioButton( i18n( "Query this master browser:" ),
                                   buttonWidget, "CustomMasterBrowserLabel" );
  KLineEdit *host_name =           new KLineEdit( buttonWidget, "kcfg_CustomMasterBrowser" );
  TQRadioButton *use_scan =         new TQRadioButton( i18n( "Scan broadcast areas:" ),
                                   buttonWidget, "BroadcastAreasLabel" );
  KLineEdit *broadcast_addresses = new KLineEdit( buttonWidget, "kcfg_BroadcastAreas" );

  buttonLayout->addWidget( use_host, 0, 0, 0 );
  buttonLayout->addWidget( host_name, 0, 1, 0 );
  buttonLayout->addWidget( use_scan, 1, 0, 0 );
  buttonLayout->addWidget( broadcast_addresses, 1, 1, 0 );

  browse_box->insert( use_host, Smb4KSettings::EnumBrowseList::QueryCustomMaster );
  browse_box->insert( use_scan, Smb4KSettings::EnumBrowseList::ScanBroadcastAreas );

  //
  // The search group box
  //
  TQButtonGroup *search_box =       new TQButtonGroup( 1, Qt::Horizontal, i18n( "Network Search" ),
                                   this, "kcfg_SearchMethod" );
  search_box->setInsideSpacing( 5 );

  TQLabel *description =            new TQLabel( search_box );
  description->setText( i18n( "Smb4K uses \"nmblookup\" by default to search for remote hosts. This method is very reliable but fails sometimes if your network neighborhood is configured uncommonly. In this case you should try to use \"smbclient\"." ) );
  description->setTextFormat( TQt::RichText );

  search_box->insert( new TQRadioButton( i18n( "Use nmblookup (recommended)" ),
                      search_box ), Smb4KSettings::EnumSearchMethod::Nmblookup );

  search_box->insert( new TQRadioButton( i18n( "Use smbclient" ),
                      search_box ), Smb4KSettings::EnumSearchMethod::Smbclient );

  TQSpacerItem *spacer4 =           new TQSpacerItem( 0, 0, TQSizePolicy::Preferred, TQSizePolicy::Expanding );

  grid->addWidget( browse_box, 0, 0, 0 );
  grid->addWidget( search_box, 1, 0, 0 );
  grid->addItem( spacer4, 2, 0 );
}


Smb4KNetworkOptions::~Smb4KNetworkOptions()
{
}


#include "smb4knetworkoptions.moc"
