/***************************************************************************
    smb4knetworkbrowser  -  The network browser widget of Smb4K.
                             -------------------
    begin                : Mo Jan 8 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,   *
 *   MA  02110-1301 USA                                                    *
 ***************************************************************************/

// TQt includes
#include <tqheader.h>
#include <tqtimer.h>

// KDE includes
#include <klocale.h>

// application specific includes
#include "smb4knetworkbrowser.h"
#include "smb4knetworkbrowseritem.h"
#include "smb4knetworkbrowsertooltip.h"
#include "../core/smb4ksettings.h"


Smb4KNetworkBrowser::Smb4KNetworkBrowser( TQWidget *parent, const char *name )
: KListView( parent, name )
{
  setRootIsDecorated( true );
  setAllColumnsShowFocus( false );
  setMouseTracking( true );

  m_tooltip = NULL;
  m_block_tooltip = false;

  addColumn( i18n( "Network" ), -1 );
  addColumn( i18n( "Type" ), -1 );
  addColumn( i18n( "IP Address" ), -1 );
  addColumn( i18n( "Comment" ), -1 );

  // Add some connections:
  connect( this, TQT_SIGNAL( expanded( TQListViewItem * ) ),
           this, TQT_SLOT( slotItemExpandedCollapsed( TQListViewItem * ) ) );

  connect( this, TQT_SIGNAL( collapsed( TQListViewItem * ) ),
           this, TQT_SLOT( slotItemExpandedCollapsed( TQListViewItem * ) ) );

  connect( this, TQT_SIGNAL( executed( TQListViewItem * ) ),
           this, TQT_SLOT( slotItemExecuted( TQListViewItem * ) ) );
}


Smb4KNetworkBrowser::~Smb4KNetworkBrowser()
{
}


void Smb4KNetworkBrowser::blockToolTips( bool block )
{
  if ( block )
  {
    delete m_tooltip;
    m_tooltip = NULL;
  }

  m_block_tooltip = block;
}


void Smb4KNetworkBrowser::contentsMouseMoveEvent( TQMouseEvent *e )
{
  // Store the *global* position of the mouse:
  m_pos = e->globalPos();

  // Find the item over which the user moved the mouse:
  Smb4KNetworkBrowserItem *item = static_cast<Smb4KNetworkBrowserItem *>( itemAt( viewport()->mapFromGlobal( m_pos ) ) );

  if ( item )
  {
    // Check if we are on the root decoration:
    bool on_root = true;

    if ( viewport()->mapFromGlobal( m_pos ).x() > header()->sectionPos( header()->mapToIndex( 0 ) ) +
         treeStepSize() * ( item->depth() + ( rootIsDecorated() ? 1 : 0 ) ) + itemMargin() ||
         viewport()->mapFromGlobal( m_pos ).x() < header()->sectionPos( header()->mapToIndex( 0 ) ) )
    {
      on_root = false;
    }

    if ( !on_root )
    {
      if ( m_tooltip )
      {
        if ( m_tooltip->item() != item )
        {
          delete m_tooltip;

          if ( !m_block_tooltip && hasMouse() && isExecuteArea( viewport()->mapFromGlobal( m_pos ) ) &&
               Smb4KSettings::showNetworkItemToolTip() )
          {
            m_tooltip = new Smb4KNetworkBrowserToolTip( item );

            TQTimer::singleShot( 2000, this, TQT_SLOT( slotShowToolTip() ) );
          }
          else
          {
            m_tooltip = NULL;
          }
        }
        else
        {
          // Do nothing
        }
      }
      else
      {
        if ( !m_block_tooltip && hasMouse() && isExecuteArea( viewport()->mapFromGlobal( m_pos ) ) &&
             Smb4KSettings::showNetworkItemToolTip() )
        {
          m_tooltip = new Smb4KNetworkBrowserToolTip( item );

          TQTimer::singleShot( 2000, this, TQT_SLOT( slotShowToolTip() ) );
        }
        else
        {
          // Do nothing
        }
      }
    }
    else
    {
      delete m_tooltip;
      m_tooltip = NULL;
    }
  }
  else
  {
    if ( m_tooltip )
    {
      delete m_tooltip;
      m_tooltip = NULL;
    }
  }

  KListView::contentsMouseMoveEvent( e );
}


/////////////////////////////////////////////////////////////////////////////
// TQT_SLOT IMPLEMENTATIONS
/////////////////////////////////////////////////////////////////////////////

void Smb4KNetworkBrowser::slotItemExpandedCollapsed( TQListViewItem *item )
{
  // Explicitly select the item, because this won't be
  // done if the user clicked on the root decoration.

  setSelected( item, true );
}


void Smb4KNetworkBrowser::slotItemExecuted( TQListViewItem *item )
{
  if ( m_tooltip )
  {
    delete m_tooltip;
    m_tooltip = NULL;
  }

  if ( item && item->isExpandable() )
  {
    setOpen( item, !item->isOpen() );
  }
}


void Smb4KNetworkBrowser::slotShowToolTip()
{
  Smb4KNetworkBrowserItem *item = static_cast<Smb4KNetworkBrowserItem *>( itemAt( viewport()->mapFromGlobal( m_pos ) ) );

  if ( !m_block_tooltip && m_tooltip && hasMouse() &&
       isExecuteArea( viewport()->mapFromGlobal( m_pos ) ) &&
       Smb4KSettings::showNetworkItemToolTip() &&
       (m_tooltip->item() == item) )
  {
    emit aboutToShowToolTip( item );

    m_tooltip->showTip( m_pos );
  }
  else
  {
    delete m_tooltip;
    m_tooltip = NULL;
  }
}

#include "smb4knetworkbrowser.moc"
