
/* -*- c-basic-offset: 4 indent-tabs-mode: nil -*- vi:set ts=8 sts=4 sw=4: */

/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_COLLAPSINGFRAME_H_
#define _RG_COLLAPSINGFRAME_H_

#include <tqframe.h>
#include <tqstring.h>


class TQWidget;
class TQToolButton;
class TQGridLayout;


namespace Rosegarden
{



class CollapsingFrame : public TQFrame
{
    Q_OBJECT
  TQ_OBJECT

public:
    CollapsingFrame(TQString label, TQWidget *parent = 0, const char *name = 0);
    virtual ~CollapsingFrame();

    TQFont font() const;
    void setFont(TQFont font);

    /// If true, the widget fills the available space.  Call before setWidget
    void setWidgetFill(bool fill);

    /// This frame contains a single other widget.  Set it here.
    void setWidget(TQWidget *w);

public slots:
    void toggle();

protected:
    TQGridLayout *m_layout;
    TQToolButton *m_toggleButton;
    TQWidget *m_widget;
    bool m_fill;
    bool m_collapsed;
};



}

#endif
