// -*- c-basic-offset: 4 -*-

/*
    Rosegarden
    A sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <bownie@bownie.com>

    This file contains code borrowed from KDevelop 2.0
    Copyright (c) The KDevelop Development Team.
 
    The moral right of the authors to claim authorship of this work
    has been asserted.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#include <unistd.h>
#include <kapplication.h>

#include <tqpainter.h>
#include <tqfontmetrics.h>

#include <kapp.h>
#include <kstddirs.h>
#include <kconfig.h>
#include <ktip.h>

#include "KStartupLogo.h"
#include "misc/Debug.h"

KStartupLogo::KStartupLogo(TQWidget * parent, const char *name)
        : TQWidget(parent, name,
                  WStyle_Customize |
                  WStyle_Splash
                 ),
	  m_readyToHide(false),
	  m_showTip(true)
{
    TQString pixmapFile = locate("appdata", "pixmaps/splash.png");
    if (!pixmapFile)
        return ;
    m_pixmap.load(pixmapFile);
    setBackgroundPixmap(m_pixmap);
    setGeometry(TQApplication::desktop()->width() / 2 - m_pixmap.width() / 2,
                TQApplication::desktop()->height() / 2 - m_pixmap.height() / 2,
                m_pixmap.width(), m_pixmap.height());
}

KStartupLogo::~KStartupLogo()
{
    m_wasClosed = true;
    m_instance = 0;
}

void KStartupLogo::paintEvent(TQPaintEvent*)
{
    // Print version number
    TQPainter paint(this);

    TQFont defaultFont;
    defaultFont.setPixelSize(12);
    paint.setFont(defaultFont);

    TQFontMetrics metrics(defaultFont);
    int width = metrics.width(m_statusMessage) + 6;
    if (width > 200)
        width = 200;

    int y = m_pixmap.height() - 12;

    // grep me: splash color
    //    TQColor bg(49, 94, 19); // color for 2006 splash
    TQColor bg(19, 19, 19);  // color for the 2008 splash
    paint.setPen(bg);
    paint.setBrush(bg);
    paint.drawRect(TQRect(m_pixmap.width() - 220, m_pixmap.height() - 43,
                         220, (y + 8) - (m_pixmap.height() - 43)));

    //    paint.setPen(TQt::black);
    //    paint.setBrush(TQt::black);
    paint.setPen(TQt::white);
    paint.setBrush(TQt::white);

    //TQString version(VERSION);
    //int sepIdx = version.find("-");
    TQString versionLabel(VERSION);
    //TQString("R%1 v%2").arg(version.left(sepIdx)).arg(version.mid(sepIdx + 1));
    int versionWidth = metrics.width(versionLabel);

    paint.drawText(m_pixmap.width() - versionWidth - 18,
                   m_pixmap.height() - 28,
                   versionLabel);

    paint.drawText(m_pixmap.width() - (width + 10), y, m_statusMessage);
}

void KStartupLogo::slotShowStatusMessage(TQString message)
{
    m_statusMessage = message;
    paintEvent(0);
    TQApplication::flushX();
}

void KStartupLogo::close()
{
    if (!m_wasClosed && isVisible()) {

	if (m_showTip) {
	    RG_DEBUG << "KStartupLogo::close: Showing Tips\n";
	    KTipDialog::showTip(locate("data", "rosegarden/tips"));
	}
    }

    TQWidget::close();
}


void KStartupLogo::mousePressEvent(TQMouseEvent*)
{
    // for the haters of raising startlogos
    if (m_readyToHide)
        hide(); // don't close, main() sets up a TQTimer for that
}

KStartupLogo* KStartupLogo::getInstance()
{
    if (m_wasClosed)
        return 0;

    if (!m_instance)
        m_instance = new KStartupLogo;

    return m_instance;
}

void KStartupLogo::hideIfStillThere()
{
    if (m_instance)
        m_instance->hide();
    // don't close, main() sets up a TQTimer for that
}


KStartupLogo* KStartupLogo::m_instance = 0;
bool KStartupLogo::m_wasClosed = false;

#include "KStartupLogo.moc"
